/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.common.ReactorResources;
import discord4j.rest.http.client.ClientResponse;
import discord4j.rest.http.client.DiscordWebClient;
import discord4j.rest.request.BucketKey;
import discord4j.rest.request.DiscordWebRequest;
import discord4j.rest.request.DiscordWebResponse;
import discord4j.rest.request.RequestCorrelation;
import discord4j.rest.request.RequestStream;
import discord4j.rest.request.ResponseHeaderStrategy;
import discord4j.rest.request.Router;
import discord4j.rest.request.RouterOptions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

public class DefaultRouter
implements Router {
    private static final Logger log = Loggers.getLogger(DefaultRouter.class);
    private static final ResponseHeaderStrategy HEADER_STRATEGY = new ResponseHeaderStrategy();
    private final ReactorResources reactorResources;
    private final DiscordWebClient httpClient;
    private final Map<BucketKey, RequestStream> streamMap = new ConcurrentHashMap<BucketKey, RequestStream>();
    private final RouterOptions routerOptions;

    public DefaultRouter(RouterOptions routerOptions) {
        this.routerOptions = routerOptions;
        this.reactorResources = routerOptions.getReactorResources();
        this.httpClient = new DiscordWebClient(this.reactorResources.getHttpClient(), routerOptions.getExchangeStrategies(), "Bot", routerOptions.getToken(), routerOptions.getResponseTransformers());
    }

    @Override
    public DiscordWebResponse exchange(DiscordWebRequest request) {
        return new DiscordWebResponse((Mono<ClientResponse>)Mono.deferWithContext(ctx -> {
            RequestStream stream = this.getStream(request);
            MonoProcessor callback = MonoProcessor.create();
            stream.push(new RequestCorrelation<ClientResponse>(request, (MonoProcessor<ClientResponse>)callback, (Context)ctx));
            return callback;
        }).checkpoint("Request to " + request.getDescription() + " [DefaultRouter]"), this.reactorResources);
    }

    private RequestStream getStream(DiscordWebRequest request) {
        return this.streamMap.computeIfAbsent(BucketKey.of(request), k -> {
            if (log.isTraceEnabled()) {
                log.trace("Creating RequestStream with key {} for request: {} -> {}", new Object[]{k, request.getRoute().getUriTemplate(), request.getCompleteUri()});
            }
            RequestStream stream = new RequestStream((BucketKey)k, this.routerOptions, this.httpClient, HEADER_STRATEGY);
            stream.start();
            return stream;
        });
    }
}

