/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import discord4j.rest.http.ReaderStrategy;
import io.netty.buffer.ByteBuf;
import io.netty.util.IllegalReferenceCountException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class JacksonReaderStrategy<T>
implements ReaderStrategy<T> {
    private static final Logger log = Loggers.getLogger(JacksonReaderStrategy.class);
    private final ObjectMapper objectMapper;

    public JacksonReaderStrategy(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canRead(@Nullable Class<?> type, @Nullable String contentType) {
        if (type == null || contentType == null || !contentType.startsWith("application/json")) {
            return false;
        }
        return !CharSequence.class.isAssignableFrom(type) && this.objectMapper.canDeserialize(this.getJavaType(type));
    }

    private JavaType getJavaType(Type type) {
        return this.objectMapper.getTypeFactory().constructType(type);
    }

    @Override
    public Mono<T> read(Mono<ByteBuf> content, Class<T> responseType) {
        return ((Mono)content.as(JacksonReaderStrategy::byteArray)).flatMap(bytes -> Mono.deferWithContext(ctx -> Mono.fromCallable(() -> {
            if (log.isTraceEnabled()) {
                log.trace("{}", new Object[]{new String((byte[])bytes, StandardCharsets.UTF_8)});
            }
            try {
                return this.objectMapper.readValue(bytes, responseType);
            }
            catch (JsonProcessingException e) {
                throw Exceptions.propagate((Throwable)new RuntimeException(e.toString().replaceAll("(\"token\": ?\")([A-Za-z0-9._-]*)(\")", "$1hunter2$3")));
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        })));
    }

    private static Mono<byte[]> byteArray(Mono<ByteBuf> byteBufMono) {
        return byteBufMono.handle((buf, sink) -> {
            try {
                byte[] bytes = new byte[buf.readableBytes()];
                buf.readBytes(bytes);
                sink.next((Object)bytes);
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }
}

