/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.BulkDeleteRequest;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ChannelModifyRequest;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.GroupAddRecipientRequest;
import discord4j.discordjson.json.InviteCreateRequest;
import discord4j.discordjson.json.InviteData;
import discord4j.discordjson.json.MessageCreateRequest;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.PermissionsEditRequest;
import discord4j.discordjson.json.WebhookData;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestMessage;
import discord4j.rest.util.MultipartRequest;
import discord4j.rest.util.PaginationUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestChannel {
    private final RestClient restClient;
    private final long id;

    private RestChannel(RestClient restClient, long id) {
        this.restClient = restClient;
        this.id = id;
    }

    public static RestChannel create(RestClient restClient, Snowflake id) {
        return new RestChannel(restClient, id.asLong());
    }

    static RestChannel create(RestClient restClient, long id) {
        return new RestChannel(restClient, id);
    }

    public Mono<ChannelData> getData() {
        return this.restClient.getChannelService().getChannel(this.id);
    }

    public RestMessage message(Snowflake messageId) {
        return RestMessage.create(this.restClient, this.id, messageId.asLong());
    }

    public Mono<ChannelData> modify(ChannelModifyRequest request, @Nullable String reason) {
        return this.restClient.getChannelService().modifyChannel(this.id, request, reason);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.restClient.getChannelService().deleteChannel(this.id, reason).then();
    }

    public Flux<MessageData> getMessagesBefore(Snowflake messageId) {
        Function doRequest = params -> this.restClient.getChannelService().getMessages(this.id, (Map<String, Object>)params);
        return PaginationUtil.paginateBefore(doRequest, data -> Snowflake.asLong((String)data.id()), messageId.asLong(), 100);
    }

    public Flux<MessageData> getMessagesAfter(Snowflake messageId) {
        Function doRequest = params -> this.restClient.getChannelService().getMessages(this.id, (Map<String, Object>)params);
        return PaginationUtil.paginateAfter(doRequest, data -> Snowflake.asLong((String)data.id()), messageId.asLong(), 100);
    }

    public RestMessage getRestMessage(Snowflake messageId) {
        return RestMessage.create(this.restClient, this.id, messageId.asLong());
    }

    public Mono<MessageData> createMessage(MessageCreateRequest request) {
        return this.restClient.getChannelService().createMessage(this.id, new MultipartRequest(request));
    }

    public Mono<MessageData> createMessage(MultipartRequest request) {
        return this.restClient.getChannelService().createMessage(this.id, request);
    }

    public Mono<MessageData> createMessage(String content) {
        return this.createMessage((MessageCreateRequest)MessageCreateRequest.builder().content(content).build());
    }

    public Mono<MessageData> createMessage(EmbedData embed) {
        return this.createMessage((MessageCreateRequest)MessageCreateRequest.builder().embed(embed).build());
    }

    public Flux<Snowflake> bulkDelete(Publisher<Snowflake> messageIds) {
        Instant timeLimit = Instant.now().minus(Duration.ofDays(14L));
        ArrayList ignoredMessageIds = new ArrayList(0);
        Predicate<Snowflake> filterMessageId = messageId -> {
            if (timeLimit.isAfter(messageId.getTimestamp())) {
                ignoredMessageIds.add(messageId);
                return false;
            }
            return true;
        };
        Function<List, Mono> filterMessageIdChunk = messageIdChunk -> Mono.just(messageIdChunk.get(0)).filter(ignore -> messageIdChunk.size() == 1).flatMap(id -> this.restClient.getChannelService().deleteMessage(this.id, Long.parseLong(id), null).thenReturn(id)).hasElement().map(identity -> identity == false);
        return Flux.defer(() -> messageIds).distinct().filter(filterMessageId).map(Snowflake::asString).buffer(100).filterWhen(filterMessageIdChunk).flatMap(messageIdChunk -> this.restClient.getChannelService().bulkDeleteMessages(this.id, (BulkDeleteRequest)BulkDeleteRequest.builder().messages((Iterable)messageIdChunk).build())).thenMany((Publisher)Flux.fromIterable(ignoredMessageIds));
    }

    public Mono<Void> editChannelPermissions(Snowflake targetId, PermissionsEditRequest request, @Nullable String reason) {
        return this.restClient.getChannelService().editChannelPermissions(this.id, targetId.asLong(), request, reason);
    }

    public Flux<InviteData> getInvites() {
        return this.restClient.getChannelService().getChannelInvites(this.id);
    }

    public Mono<InviteData> createInvite(InviteCreateRequest request, @Nullable String reason) {
        return this.restClient.getChannelService().createChannelInvite(this.id, request, reason);
    }

    public Mono<Void> deleteChannelPermission(Snowflake targetId, @Nullable String reason) {
        return this.restClient.getChannelService().deleteChannelPermission(this.id, targetId.asLong(), reason);
    }

    public Mono<Void> type() {
        return this.restClient.getChannelService().triggerTypingIndicator(this.id);
    }

    public Flux<MessageData> getPinnedMessages() {
        return this.restClient.getChannelService().getPinnedMessages(this.id);
    }

    public Mono<Void> addPinnedMessage(Snowflake messageId) {
        return this.restClient.getChannelService().addPinnedMessage(this.id, messageId.asLong());
    }

    public Mono<Void> deletePinnedMessage(Snowflake messageId) {
        return this.restClient.getChannelService().deletePinnedMessage(this.id, messageId.asLong());
    }

    public Mono<Void> addGroupDMRecipient(Snowflake userId, GroupAddRecipientRequest request) {
        return this.restClient.getChannelService().addGroupDMRecipient(this.id, userId.asLong(), request);
    }

    public Mono<Void> deleteGroupDMRecipient(Snowflake userId) {
        return this.restClient.getChannelService().deleteGroupDMRecipient(this.id, userId.asLong());
    }

    public Flux<WebhookData> getWebhooks() {
        return this.restClient.getWebhookService().getChannelWebhooks(this.id);
    }
}

