/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.common.json.UserResponse;
import discord4j.rest.json.request.DMCreateRequest;
import discord4j.rest.json.request.GroupDMCreateRequest;
import discord4j.rest.json.request.UserModifyRequest;
import discord4j.rest.json.response.ChannelResponse;
import discord4j.rest.json.response.ConnectionResponse;
import discord4j.rest.json.response.UserGuildResponse;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UserService
extends RestService {
    public UserService(Router router) {
        super(router);
    }

    public Mono<UserResponse> getCurrentUser() {
        return Routes.CURRENT_USER_GET.newRequest(new Object[0]).exchange(this.getRouter());
    }

    public Mono<UserResponse> getUser(long userId) {
        return Routes.USER_GET.newRequest(userId).exchange(this.getRouter());
    }

    public Mono<UserResponse> modifyCurrentUser(UserModifyRequest request) {
        return Routes.CURRENT_USER_MODIFY.newRequest(new Object[0]).body(request).exchange(this.getRouter());
    }

    public Flux<UserGuildResponse> getCurrentUserGuilds(Map<String, Object> queryParams) {
        return Routes.CURRENT_USER_GUILDS_GET.newRequest(new Object[0]).query(queryParams).exchange(this.getRouter()).flatMapMany(Flux::fromArray);
    }

    public Mono<Void> leaveGuild(long guildId) {
        return Routes.GUILD_LEAVE.newRequest(guildId).exchange(this.getRouter());
    }

    public Flux<ChannelResponse> getUserDMs() {
        return Routes.USER_DMS_GET.newRequest(new Object[0]).exchange(this.getRouter()).flatMapMany(Flux::fromArray);
    }

    public Mono<ChannelResponse> createDM(DMCreateRequest request) {
        return Routes.USER_DM_CREATE.newRequest(new Object[0]).body(request).exchange(this.getRouter());
    }

    public Mono<ChannelResponse> createGroupDM(GroupDMCreateRequest request) {
        return Routes.GROUP_DM_CREATE.newRequest(new Object[0]).body(request).exchange(this.getRouter());
    }

    public Flux<ConnectionResponse> getUserConnections() {
        return Routes.USER_CONNECTIONS_GET.newRequest(new Object[0]).exchange(this.getRouter()).flatMapMany(Flux::fromArray);
    }
}

