/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.common.annotations.Experimental;
import discord4j.rest.request.GlobalRateLimiter;
import discord4j.rest.request.SemaphoreGlobalRateLimiter;
import discord4j.rest.response.ResponseFunction;
import java.util.ArrayList;
import java.util.List;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.annotation.Nullable;

public class RouterOptions {
    public static final Scheduler DEFAULT_RESPONSE_SCHEDULER = Schedulers.elastic();
    public static final Scheduler DEFAULT_RATE_LIMIT_SCHEDULER = Schedulers.elastic();
    public static final int DEFAULT_REQUEST_PARALLELISM = 8;
    private final Scheduler responseScheduler;
    private final Scheduler rateLimitScheduler;
    private final List<ResponseFunction> responseTransformers;
    private final int requestParallelism;
    private final GlobalRateLimiter globalRateLimiter;

    protected RouterOptions(Builder builder) {
        this.responseScheduler = builder.responseScheduler;
        this.rateLimitScheduler = builder.rateLimitScheduler;
        this.responseTransformers = builder.responseTransformers;
        if (builder.globalRateLimiter != null) {
            this.requestParallelism = -1;
            this.globalRateLimiter = builder.globalRateLimiter;
        } else {
            this.requestParallelism = builder.requestParallelism;
            this.globalRateLimiter = new SemaphoreGlobalRateLimiter(builder.requestParallelism);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RouterOptions create() {
        return RouterOptions.builder().build();
    }

    public Scheduler getResponseScheduler() {
        return this.responseScheduler;
    }

    public Scheduler getRateLimitScheduler() {
        return this.rateLimitScheduler;
    }

    public List<ResponseFunction> getResponseTransformers() {
        return this.responseTransformers;
    }

    @Deprecated
    public int getRequestParallelism() {
        return this.requestParallelism;
    }

    public GlobalRateLimiter getGlobalRateLimiter() {
        return this.globalRateLimiter;
    }

    public static class Builder {
        private Scheduler responseScheduler = DEFAULT_RESPONSE_SCHEDULER;
        private Scheduler rateLimitScheduler = DEFAULT_RATE_LIMIT_SCHEDULER;
        private final List<ResponseFunction> responseTransformers = new ArrayList<ResponseFunction>();
        private int requestParallelism = 8;
        @Nullable
        private GlobalRateLimiter globalRateLimiter;

        protected Builder() {
        }

        public Builder responseScheduler(Scheduler responseScheduler) {
            this.responseScheduler = responseScheduler;
            return this;
        }

        public Builder rateLimitScheduler(Scheduler rateLimitScheduler) {
            this.rateLimitScheduler = rateLimitScheduler;
            return this;
        }

        @Experimental
        public Builder onClientResponse(ResponseFunction errorHandler) {
            this.responseTransformers.add(errorHandler);
            return this;
        }

        public Builder requestParallelism(int requestParallelism) {
            this.requestParallelism = requestParallelism;
            return this;
        }

        public Builder globalRateLimiter(GlobalRateLimiter globalRateLimiter) {
            this.globalRateLimiter = globalRateLimiter;
            return this;
        }

        public RouterOptions build() {
            return new RouterOptions(this);
        }
    }
}

