/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.json.request;

import discord4j.common.jackson.Possible;
import discord4j.common.json.EmbedFieldEntity;
import discord4j.rest.json.request.EmbedAuthorRequest;
import discord4j.rest.json.request.EmbedFooterRequest;
import discord4j.rest.json.request.EmbedImageRequest;
import discord4j.rest.json.request.EmbedThumbnailRequest;

public class EmbedRequest {
    private final Possible<String> title;
    private final Possible<String> description;
    private final Possible<String> url;
    private final Possible<String> timestamp;
    private final Possible<Integer> color;
    private final Possible<EmbedFooterRequest> footer;
    private final Possible<EmbedImageRequest> image;
    private final Possible<EmbedThumbnailRequest> thumbnail;
    private final Possible<EmbedAuthorRequest> author;
    private final Possible<EmbedFieldEntity[]> fields;

    public EmbedRequest(Possible<String> title, Possible<String> description, Possible<String> url, Possible<String> timestamp, Possible<Integer> color, Possible<EmbedFooterRequest> footer, Possible<EmbedImageRequest> image, Possible<EmbedThumbnailRequest> thumbnail, Possible<EmbedAuthorRequest> author, Possible<EmbedFieldEntity[]> fields) {
        this.title = title;
        this.description = description;
        this.url = url;
        this.timestamp = timestamp;
        this.color = color;
        this.footer = footer;
        this.image = image;
        this.thumbnail = thumbnail;
        this.author = author;
        this.fields = fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "EmbedRequest{title=" + this.title + ", description=" + this.description + ", url=" + this.url + ", timestamp=" + this.timestamp + ", color=" + this.color + ", footer=" + this.footer + ", image=" + this.image + ", thumbnail=" + this.thumbnail + ", author=" + this.author + ", fields=" + this.fields + '}';
    }

    public static class Builder {
        private Possible<String> title;
        private Possible<String> description;
        private Possible<String> url;
        private Possible<String> timestamp;
        private Possible<Integer> color;
        private Possible<EmbedFooterRequest> footer;
        private Possible<EmbedImageRequest> image;
        private Possible<EmbedThumbnailRequest> thumbnail;
        private Possible<EmbedAuthorRequest> author;
        private Possible<EmbedFieldEntity[]> fields;

        public Builder title(String title) {
            this.title = Possible.of((Object)title);
            return this;
        }

        public Builder description(String description) {
            this.description = Possible.of((Object)description);
            return this;
        }

        public Builder url(String url) {
            this.url = Possible.of((Object)url);
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timestamp = Possible.of((Object)timestamp);
            return this;
        }

        public Builder color(Integer color) {
            this.color = Possible.of((Object)color);
            return this;
        }

        public Builder footer(EmbedFooterRequest footer) {
            this.footer = Possible.of((Object)footer);
            return this;
        }

        public Builder image(EmbedImageRequest image) {
            this.image = Possible.of((Object)image);
            return this;
        }

        public Builder thumbnail(EmbedThumbnailRequest thumbnail) {
            this.thumbnail = Possible.of((Object)thumbnail);
            return this;
        }

        public Builder author(EmbedAuthorRequest author) {
            this.author = Possible.of((Object)author);
            return this;
        }

        public Builder fields(EmbedFieldEntity[] fields) {
            this.fields = Possible.of((Object)fields);
            return this;
        }

        public EmbedRequest build() {
            return new EmbedRequest(this.title, this.description, this.url, this.timestamp, this.color, this.footer, this.image, this.thumbnail, this.author, this.fields);
        }
    }
}

