/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.response;

import discord4j.common.annotations.Experimental;
import discord4j.rest.request.DiscordRequest;
import discord4j.rest.request.RouteMatcher;
import discord4j.rest.response.ResponseFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;

@Experimental
public class ResumingTransformer
implements ResponseFunction {
    private final RouteMatcher routeMatcher;
    private final Predicate<Throwable> predicate;
    private Function<Throwable, Mono<?>> fallback;

    public ResumingTransformer(RouteMatcher routeMatcher, Predicate<Throwable> predicate, Function<Throwable, Mono<?>> fallback) {
        this.routeMatcher = routeMatcher;
        this.predicate = predicate;
        this.fallback = fallback;
    }

    @Override
    public <T> Function<Mono<T>, Mono<T>> transform(DiscordRequest<T> request) {
        if (this.routeMatcher.matches(request)) {
            return mono -> mono.onErrorResume(this.predicate, this.adaptFallback(this.fallback));
        }
        return mono -> mono;
    }

    private <T> Function<? super Throwable, ? extends Mono<? extends T>> adaptFallback(Function<? super Throwable, ? extends Mono<?>> fallback) {
        return fallback;
    }
}

