/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.common.annotations.Experimental;
import discord4j.rest.request.DiscordRequest;
import discord4j.rest.route.Route;
import java.util.Map;
import java.util.function.Predicate;
import reactor.util.annotation.Nullable;

@Experimental
public class RouteMatcher {
    @Nullable
    private final DiscordRequest<?> request;
    @Nullable
    private final Predicate<Map<String, String>> requestVariableMatcher;

    private RouteMatcher(DiscordRequest<?> request) {
        this(request, null);
    }

    public RouteMatcher(DiscordRequest<?> request, Predicate<Map<String, String>> requestVariableMatcher) {
        this.request = request;
        this.requestVariableMatcher = requestVariableMatcher;
    }

    public static RouteMatcher any() {
        return new RouteMatcher(null);
    }

    public static RouteMatcher route(Route<?> route) {
        return new RouteMatcher(route.newRequest(new Object[0]));
    }

    public static RouteMatcher route(Route<?> route, Predicate<Map<String, String>> requestVariableMatcher) {
        return new RouteMatcher(route.newRequest(new Object[0]), requestVariableMatcher);
    }

    public boolean matches(DiscordRequest<?> otherRequest) {
        return this.matchesRoute(otherRequest) && this.matchesVariables(otherRequest);
    }

    private boolean matchesRoute(DiscordRequest<?> otherRequest) {
        return this.request == null || this.request.getRoute().equals(otherRequest.getRoute());
    }

    private boolean matchesVariables(DiscordRequest<?> otherRequest) {
        return this.requestVariableMatcher == null || otherRequest.matchesVariables(this.requestVariableMatcher);
    }
}

