/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.json.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import discord4j.common.jackson.Possible;
import discord4j.common.jackson.PossibleJson;
import discord4j.common.jackson.PossibleLong;
import discord4j.common.jackson.UnsignedJson;
import reactor.util.annotation.Nullable;

@PossibleJson
public class GuildModifyRequest {
    private final Possible<String> name;
    private final Possible<String> region;
    @JsonProperty(value="verification_level")
    private final Possible<Integer> verificationLevel;
    @JsonProperty(value="default_message_notifications")
    private final Possible<Integer> defaultMessageNotifications;
    @JsonProperty(value="afk_channel_id")
    @Nullable
    @UnsignedJson
    private final PossibleLong afkChannelId;
    @JsonProperty(value="afk_timeout")
    private final Possible<Integer> afkTimeout;
    @Nullable
    private final Possible<String> icon;
    @JsonProperty(value="owner_id")
    @UnsignedJson
    private final PossibleLong ownerId;
    @Nullable
    private final Possible<String> splash;
    @Nullable
    private final Possible<String> banner;

    public GuildModifyRequest(Possible<String> name, Possible<String> region, Possible<Integer> verificationLevel, Possible<Integer> defaultMessageNotifications, @Nullable PossibleLong afkChannelId, Possible<Integer> afkTimeout, @Nullable Possible<String> icon, PossibleLong ownerId, @Nullable Possible<String> splash, @Nullable Possible<String> banner) {
        this.name = name;
        this.region = region;
        this.verificationLevel = verificationLevel;
        this.defaultMessageNotifications = defaultMessageNotifications;
        this.afkChannelId = afkChannelId;
        this.afkTimeout = afkTimeout;
        this.icon = icon;
        this.ownerId = ownerId;
        this.splash = splash;
        this.banner = banner;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "GuildModifyRequest{name=" + this.name + ", region=" + this.region + ", verificationLevel=" + this.verificationLevel + ", defaultMessageNotifications=" + this.defaultMessageNotifications + ", afkChannelId=" + this.afkChannelId + ", afkTimeout=" + this.afkTimeout + ", icon=" + this.icon + ", ownerId=" + this.ownerId + ", splash=" + this.splash + ", banner=" + this.banner + '}';
    }

    public static class Builder {
        private Possible<String> name = Possible.absent();
        private Possible<String> region = Possible.absent();
        private Possible<Integer> verificationLevel = Possible.absent();
        private Possible<Integer> defaultMessageNotifications = Possible.absent();
        @Nullable
        private PossibleLong afkChannelId = PossibleLong.absent();
        private Possible<Integer> afkTimeout = Possible.absent();
        @Nullable
        private Possible<String> icon = Possible.absent();
        private PossibleLong ownerId = PossibleLong.absent();
        @Nullable
        private Possible<String> splash = Possible.absent();
        @Nullable
        private Possible<String> banner = Possible.absent();

        public Builder name(String name) {
            this.name = Possible.of((Object)name);
            return this;
        }

        public Builder region(String region) {
            this.region = Possible.of((Object)region);
            return this;
        }

        public Builder verificationLevel(int verificationLevel) {
            this.verificationLevel = Possible.of((Object)verificationLevel);
            return this;
        }

        public Builder defaultMessageNotifications(int defaultMessageNotifications) {
            this.defaultMessageNotifications = Possible.of((Object)defaultMessageNotifications);
            return this;
        }

        public Builder afkChannelId(@Nullable Long afkChannelId) {
            this.afkChannelId = afkChannelId == null ? null : PossibleLong.of((long)afkChannelId);
            return this;
        }

        public Builder afkTimeout(int afkTimeout) {
            this.afkTimeout = Possible.of((Object)afkTimeout);
            return this;
        }

        public Builder icon(@Nullable String icon) {
            this.icon = icon == null ? null : Possible.of((Object)icon);
            return this;
        }

        public Builder ownerId(long ownerId) {
            this.ownerId = PossibleLong.of((long)ownerId);
            return this;
        }

        public Builder splash(@Nullable String splash) {
            this.splash = splash == null ? null : Possible.of((Object)splash);
            return this;
        }

        public Builder banner(@Nullable String banner) {
            this.banner = banner == null ? null : Possible.of((Object)banner);
            return this;
        }

        public GuildModifyRequest build() {
            return new GuildModifyRequest(this.name, this.region, this.verificationLevel, this.defaultMessageNotifications, this.afkChannelId, this.afkTimeout, this.icon, this.ownerId, this.splash, this.banner);
        }
    }
}

