/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.json.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import discord4j.common.jackson.Possible;
import discord4j.common.jackson.PossibleJson;
import discord4j.common.jackson.UnsignedJson;
import reactor.util.annotation.Nullable;

@PossibleJson
public class GuildMemberAddRequest {
    @JsonProperty(value="accessToken")
    private final String accessToken;
    @Nullable
    private final Possible<String> nick;
    @UnsignedJson
    private final Possible<long[]> roles;
    private final Possible<Boolean> mute;
    private final Possible<Boolean> deaf;

    public GuildMemberAddRequest(String accessToken, @Nullable Possible<String> nick, Possible<long[]> roles, Possible<Boolean> mute, Possible<Boolean> deaf) {
        this.accessToken = accessToken;
        this.nick = nick;
        this.roles = roles;
        this.mute = mute;
        this.deaf = deaf;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "GuildMemberAddRequest{accessToken='" + this.accessToken + '\'' + ", nick=" + this.nick + ", roles=" + this.roles + ", mute=" + this.mute + ", deaf=" + this.deaf + '}';
    }

    public static class Builder {
        private String accessToken;
        private Possible<String> nick = Possible.absent();
        private Possible<long[]> roles = Possible.absent();
        private Possible<Boolean> mute = Possible.absent();
        private Possible<Boolean> deaf = Possible.absent();

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder nick(String nick) {
            this.nick = Possible.of((Object)nick);
            return this;
        }

        public Builder roles(long[] roles) {
            this.roles = Possible.of((Object)roles);
            return this;
        }

        public Builder mute(boolean mute) {
            this.mute = Possible.of((Object)mute);
            return this;
        }

        public Builder deaf(boolean deaf) {
            this.deaf = Possible.of((Object)deaf);
            return this;
        }

        public GuildMemberAddRequest build() {
            return new GuildMemberAddRequest(this.accessToken, this.nick, this.roles, this.mute, this.deaf);
        }
    }
}

