/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.json.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import discord4j.common.jackson.Possible;
import discord4j.common.jackson.PossibleJson;
import discord4j.common.jackson.PossibleLong;
import discord4j.common.jackson.UnsignedJson;
import discord4j.common.json.OverwriteEntity;
import reactor.util.annotation.Nullable;

@PossibleJson
public class ChannelCreateRequest {
    private final String name;
    private final Possible<Integer> type;
    private final Possible<String> topic;
    private final Possible<Integer> bitrate;
    @JsonProperty(value="user_limit")
    private final Possible<Integer> userLimit;
    @JsonProperty(value="rate_limit_per_user")
    private final Possible<Integer> rateLimitPerUser;
    private final Possible<Integer> position;
    @JsonProperty(value="permission_overwrites")
    private final Possible<OverwriteEntity[]> permissionOverwrites;
    @JsonProperty(value="parent_id")
    @Nullable
    @UnsignedJson
    private final PossibleLong parentId;
    private final Possible<Boolean> nsfw;

    public ChannelCreateRequest(String name, Possible<Integer> type, @Nullable Possible<String> topic, Possible<Integer> bitrate, Possible<Integer> userLimit, Possible<Integer> rateLimitPerUser, Possible<Integer> position, Possible<OverwriteEntity[]> permissionOverwrites, @Nullable PossibleLong parentId, Possible<Boolean> nsfw) {
        this.name = name;
        this.type = type;
        this.topic = topic;
        this.bitrate = bitrate;
        this.userLimit = userLimit;
        this.rateLimitPerUser = rateLimitPerUser;
        this.position = position;
        this.permissionOverwrites = permissionOverwrites;
        this.parentId = parentId;
        this.nsfw = nsfw;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ChannelCreateRequest{name='" + this.name + '\'' + ", type=" + this.type + ", topic=" + this.topic + ", bitrate=" + this.bitrate + ", userLimit=" + this.userLimit + ", rateLimitPerUser=" + this.rateLimitPerUser + ", position=" + this.position + ", permissionOverwrites=" + this.permissionOverwrites + ", parentId=" + this.parentId + ", nsfw=" + this.nsfw + '}';
    }

    public static class Builder {
        private String name;
        private Possible<Integer> type = Possible.absent();
        @Nullable
        private Possible<String> topic = Possible.absent();
        private Possible<Integer> bitrate = Possible.absent();
        private Possible<Integer> userLimit = Possible.absent();
        private Possible<Integer> rateLimitPerUser = Possible.absent();
        private Possible<Integer> position = Possible.absent();
        private Possible<OverwriteEntity[]> permissionOverwrites = Possible.absent();
        private PossibleLong parentId = PossibleLong.absent();
        private Possible<Boolean> nsfw = Possible.absent();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(int type) {
            this.type = Possible.of((Object)type);
            return this;
        }

        public Builder topic(@Nullable String topic) {
            this.topic = topic == null ? null : Possible.of((Object)topic);
            return this;
        }

        public Builder bitrate(int bitrate) {
            this.bitrate = Possible.of((Object)bitrate);
            return this;
        }

        public Builder userLimit(int userLimit) {
            this.userLimit = Possible.of((Object)userLimit);
            return this;
        }

        public Builder rateLimitPerUser(int rateLimitPerUser) {
            this.rateLimitPerUser = Possible.of((Object)rateLimitPerUser);
            return this;
        }

        public Builder setPosition(int position) {
            this.position = Possible.of((Object)position);
            return this;
        }

        public Builder permissionOverwrites(OverwriteEntity[] permissionOverwrites) {
            this.permissionOverwrites = Possible.of((Object)permissionOverwrites);
            return this;
        }

        public Builder parentId(@Nullable Long parentId) {
            this.parentId = parentId == null ? null : PossibleLong.of((long)parentId);
            return this;
        }

        public Builder nsfw(boolean nsfw) {
            this.nsfw = Possible.of((Object)nsfw);
            return this;
        }

        public ChannelCreateRequest build() {
            return new ChannelCreateRequest(this.name, this.type, this.topic, this.bitrate, this.userLimit, this.rateLimitPerUser, this.position, this.permissionOverwrites, this.parentId, this.nsfw);
        }
    }
}

