/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http.client;

import discord4j.rest.request.DiscordRequest;
import discord4j.rest.route.Route;
import discord4j.rest.util.RouteUtils;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Optional;
import java.util.Set;

public class ClientRequest {
    private final DiscordRequest<?> request;
    private final String url;
    private final HttpHeaders headers;

    public ClientRequest(DiscordRequest<?> request) {
        this.request = request;
        this.url = RouteUtils.expandQuery(request.getCompleteUri(), request.getQueryParams());
        this.headers = Optional.ofNullable(request.getHeaders()).map(map -> map.entrySet().stream().reduce(new DefaultHttpHeaders(), (headers, entry) -> {
            String key = (String)entry.getKey();
            ((Set)entry.getValue()).forEach(value -> headers.add(key, value));
            return headers;
        }, HttpHeaders::add)).orElse((HttpHeaders)new DefaultHttpHeaders());
    }

    public HttpMethod getMethod() {
        return this.request.getRoute().getMethod();
    }

    public String getUrl() {
        return this.url;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public DiscordRequest<?> getDiscordRequest() {
        return this.request;
    }

    public Route<?> getRoute() {
        return this.request.getRoute();
    }

    public String toString() {
        return "ClientRequest{method=" + this.getMethod() + ", url='" + this.url + '\'' + ", headers=" + this.headers.copy().remove((CharSequence)HttpHeaderNames.AUTHORIZATION).toString() + '}';
    }
}

