/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.common.json.GuildEmojiResponse;
import discord4j.rest.json.request.GuildEmojiCreateRequest;
import discord4j.rest.json.request.GuildEmojiModifyRequest;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class EmojiService
extends RestService {
    public EmojiService(Router router) {
        super(router);
    }

    public Flux<GuildEmojiResponse> getGuildEmojis(long guildId) {
        return Routes.GUILD_EMOJIS_GET.newRequest(guildId).exchange(this.getRouter()).flatMapMany(Flux::fromArray);
    }

    public Mono<GuildEmojiResponse> getGuildEmoji(long guildId, long emojiID) {
        return Routes.GUILD_EMOJI_GET.newRequest(guildId, emojiID).exchange(this.getRouter());
    }

    public Mono<GuildEmojiResponse> createGuildEmoji(long guildId, GuildEmojiCreateRequest request, @Nullable String reason) {
        return Routes.GUILD_EMOJI_CREATE.newRequest(guildId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter());
    }

    public Mono<GuildEmojiResponse> modifyGuildEmoji(long guildId, long emojiId, GuildEmojiModifyRequest request, @Nullable String reason) {
        return Routes.GUILD_EMOJI_MODIFY.newRequest(guildId, emojiId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter());
    }

    public Mono<Void> deleteGuildEmoji(long guildId, long emojiId, @Nullable String reason) {
        return Routes.GUILD_EMOJI_DELETE.newRequest(guildId, emojiId).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter());
    }
}

