/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.response;

import discord4j.common.annotations.Experimental;
import discord4j.rest.request.DiscordRequest;
import discord4j.rest.request.RouteMatcher;
import discord4j.rest.response.ResponseFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.retry.Retry;

@Experimental
public class RetryingTransformer
implements ResponseFunction {
    private final RouteMatcher routeMatcher;
    private final Retry<?> retryFactory;

    public RetryingTransformer(RouteMatcher routeMatcher, Retry<?> retryFactory) {
        this.routeMatcher = routeMatcher;
        this.retryFactory = retryFactory;
    }

    @Override
    public <T> Function<Mono<T>, Mono<T>> transform(DiscordRequest<T> request) {
        if (this.routeMatcher.matches(request)) {
            return mono -> mono.retryWhen(this.retryFactory);
        }
        return mono -> mono;
    }
}

