/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.json.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import discord4j.common.jackson.Possible;
import discord4j.rest.json.request.PartialChannelRequest;
import discord4j.rest.json.request.RoleCreateRequest;
import reactor.util.annotation.Nullable;

public class GuildCreateRequest {
    private final String name;
    private final Possible<String> region;
    @Nullable
    private final Possible<String> icon;
    @JsonProperty(value="verification_level")
    private final Possible<Integer> verificationLevel;
    @JsonProperty(value="default_message_notifications")
    private final Possible<Integer> defaultMessageNotifications;
    private final Possible<RoleCreateRequest[]> roles;
    private final Possible<PartialChannelRequest[]> channels;

    public GuildCreateRequest(String name, Possible<String> region, @Nullable Possible<String> icon, Possible<Integer> verificationLevel, Possible<Integer> defaultMessageNotifications, Possible<RoleCreateRequest[]> roles, Possible<PartialChannelRequest[]> channels) {
        this.name = name;
        this.region = region;
        this.icon = icon;
        this.verificationLevel = verificationLevel;
        this.defaultMessageNotifications = defaultMessageNotifications;
        this.roles = roles;
        this.channels = channels;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "GuildCreateRequest{name='" + this.name + '\'' + ", region=" + this.region + ", icon=" + this.icon + ", verificationLevel=" + this.verificationLevel + ", defaultMessageNotifications=" + this.defaultMessageNotifications + ", roles=" + this.roles + ", channels=" + this.channels + '}';
    }

    public static class Builder {
        private String name;
        private Possible<String> region = Possible.absent();
        @Nullable
        private Possible<String> icon = Possible.absent();
        private Possible<Integer> verificationLevel = Possible.absent();
        private Possible<Integer> defaultMessageNotifications = Possible.absent();
        private Possible<RoleCreateRequest[]> roles = Possible.absent();
        private Possible<PartialChannelRequest[]> channels = Possible.absent();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder region(String region) {
            this.region = Possible.of((Object)region);
            return this;
        }

        public Builder icon(@Nullable String icon) {
            this.icon = Possible.of((Object)icon);
            return this;
        }

        public Builder verificationLevel(int verificationLevel) {
            this.verificationLevel = Possible.of((Object)verificationLevel);
            return this;
        }

        public Builder defaultMessageNotifications(int defaultMessageNotifications) {
            this.defaultMessageNotifications = Possible.of((Object)defaultMessageNotifications);
            return this;
        }

        public Builder roles(RoleCreateRequest[] roles) {
            this.roles = Possible.of((Object)roles);
            return this;
        }

        public Builder channels(PartialChannelRequest[] channels) {
            this.channels = Possible.of((Object)channels);
            return this;
        }

        public GuildCreateRequest build() {
            return new GuildCreateRequest(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotifications, this.roles, this.channels);
        }
    }
}

