/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.json.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import discord4j.common.jackson.Possible;
import discord4j.common.jackson.PossibleJson;
import discord4j.common.jackson.PossibleLong;
import discord4j.common.jackson.UnsignedJson;
import discord4j.common.json.OverwriteEntity;
import reactor.util.annotation.Nullable;

@PossibleJson
public class ChannelModifyRequest {
    private final Possible<String> name;
    private final Possible<Integer> position;
    @Nullable
    private final Possible<String> topic;
    private final Possible<Boolean> nsfw;
    private final Possible<Integer> bitrate;
    @JsonProperty(value="user_limit")
    private final Possible<Integer> userLimit;
    @JsonProperty(value="rate_limit_per_user")
    private final Possible<Integer> rateLimitPerUser;
    @JsonProperty(value="permission_overwrites")
    private final Possible<OverwriteEntity[]> permissionOverwrites;
    @JsonProperty(value="parent_id")
    @Nullable
    @UnsignedJson
    private final PossibleLong parentId;

    public ChannelModifyRequest(Possible<String> name, Possible<Integer> position, @Nullable Possible<String> topic, Possible<Boolean> nsfw, Possible<Integer> bitrate, Possible<Integer> userLimit, Possible<Integer> rateLimitPerUser, Possible<OverwriteEntity[]> permissionOverwrites, @Nullable PossibleLong parentId) {
        this.name = name;
        this.position = position;
        this.topic = topic;
        this.nsfw = nsfw;
        this.bitrate = bitrate;
        this.userLimit = userLimit;
        this.rateLimitPerUser = rateLimitPerUser;
        this.permissionOverwrites = permissionOverwrites;
        this.parentId = parentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ChannelModifyRequest{name=" + this.name + ", position=" + this.position + ", topic=" + this.topic + ", nsfw=" + this.nsfw + ", bitrate=" + this.bitrate + ", userLimit=" + this.userLimit + ", rateLimitPerUser=" + this.rateLimitPerUser + ", permissionOverwrites=" + this.permissionOverwrites + ", parentId=" + this.parentId + '}';
    }

    public static class Builder {
        private Possible<String> name = Possible.absent();
        private Possible<Integer> position = Possible.absent();
        @Nullable
        private Possible<String> topic = Possible.absent();
        private Possible<Boolean> nsfw = Possible.absent();
        private Possible<Integer> bitrate = Possible.absent();
        private Possible<Integer> userLimit = Possible.absent();
        private Possible<Integer> rateLimitPerUser = Possible.absent();
        private Possible<OverwriteEntity[]> permissionOverwrites = Possible.absent();
        @Nullable
        private PossibleLong parentId = PossibleLong.absent();

        public Builder name(String name) {
            this.name = Possible.of((Object)name);
            return this;
        }

        public Builder position(int position) {
            this.position = Possible.of((Object)position);
            return this;
        }

        public Builder topic(@Nullable String topic) {
            this.topic = topic == null ? null : Possible.of((Object)topic);
            return this;
        }

        public Builder nsfw(boolean nsfw) {
            this.nsfw = Possible.of((Object)nsfw);
            return this;
        }

        public Builder bitrate(int bitrate) {
            this.bitrate = Possible.of((Object)bitrate);
            return this;
        }

        public Builder userLimit(int userLimit) {
            this.userLimit = Possible.of((Object)userLimit);
            return this;
        }

        public Builder rateLimitPerUser(int rateLimitPerUser) {
            this.rateLimitPerUser = Possible.of((Object)rateLimitPerUser);
            return this;
        }

        public Builder permissionOverwrites(OverwriteEntity[] permissionOverwrites) {
            this.permissionOverwrites = Possible.of((Object)permissionOverwrites);
            return this;
        }

        public Builder parentId(@Nullable Long parentId) {
            this.parentId = parentId == null ? null : PossibleLong.of((long)parentId);
            return this;
        }

        public ChannelModifyRequest build() {
            return new ChannelModifyRequest(this.name, this.position, this.topic, this.nsfw, this.bitrate, this.userLimit, this.rateLimitPerUser, this.permissionOverwrites, this.parentId);
        }
    }
}

