/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http.client;

import discord4j.common.GitProperties;
import discord4j.rest.http.ExchangeStrategies;
import discord4j.rest.http.ReaderStrategy;
import discord4j.rest.http.WriterStrategy;
import discord4j.rest.http.client.ClientException;
import discord4j.rest.http.client.ClientRequest;
import discord4j.rest.json.response.ErrorResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class DiscordWebClient {
    private static final Logger log = Loggers.getLogger(DiscordWebClient.class);
    public static final String REQUEST_TIMESTAMP_KEY = "requestTimestamp";
    private final HttpClient httpClient;
    private final HttpHeaders defaultHeaders;
    private final ExchangeStrategies exchangeStrategies;

    public DiscordWebClient(HttpClient httpClient, ExchangeStrategies exchangeStrategies, String token) {
        Properties properties = GitProperties.getProperties();
        String version = properties.getProperty("git.build.version", "3");
        String url = properties.getProperty("application.url", "https://discord4j.com");
        DefaultHttpHeaders defaultHeaders = new DefaultHttpHeaders();
        defaultHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        defaultHeaders.add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)("Bot " + token));
        defaultHeaders.add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)("DiscordBot(" + url + ", " + version + ")"));
        defaultHeaders.add("X-RateLimit-Precision", (Object)"millisecond");
        this.httpClient = httpClient;
        this.defaultHeaders = defaultHeaders;
        this.exchangeStrategies = exchangeStrategies;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpHeaders getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public ExchangeStrategies getExchangeStrategies() {
        return this.exchangeStrategies;
    }

    public <R, T> Mono<T> exchange(ClientRequest request, @Nullable R body, Class<T> responseType, Consumer<HttpClientResponse> responseConsumer) {
        Objects.requireNonNull(responseType);
        HttpHeaders requestHeaders = new DefaultHttpHeaders().add(this.defaultHeaders).setAll(request.getHeaders());
        String contentType = requestHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        HttpClient.RequestSender sender = (HttpClient.RequestSender)this.httpClient.baseUrl("https://discordapp.com/api/v6").observe((connection, newState) -> log.debug("{} {}", new Object[]{newState, connection})).headers(headers -> headers.setAll(requestHeaders)).request(request.getMethod()).uri(request.getUrl());
        return this.exchangeStrategies.writers().stream().filter(s -> s.canWrite(body != null ? body.getClass() : null, contentType)).findFirst().map(DiscordWebClient::cast).map(writer -> writer.write(sender, body)).orElseGet(() -> Mono.error((Throwable)DiscordWebClient.noWriterException(body, contentType))).flatMap(receiver -> receiver.responseSingle((response, content) -> {
            responseConsumer.accept((HttpClientResponse)response);
            String responseContentType = response.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            Optional<ReaderStrategy> readerStrategy = this.exchangeStrategies.readers().stream().filter(s -> s.canRead(responseType, responseContentType)).findFirst();
            int responseStatus = response.status().code();
            if (responseStatus >= 400 && responseStatus < 600) {
                return Mono.justOrEmpty(readerStrategy).map(DiscordWebClient::cast).flatMap(s -> s.read((ByteBufMono)content, ErrorResponse.class)).flatMap(s -> Mono.error((Throwable)DiscordWebClient.clientException(request, response, s))).switchIfEmpty(Mono.error((Throwable)DiscordWebClient.clientException(request, response, null)));
            }
            return readerStrategy.map(DiscordWebClient::cast).map(s -> s.read((ByteBufMono)content, responseType)).orElseGet(() -> Mono.error((Throwable)DiscordWebClient.noReaderException(responseType, responseContentType)));
        })).subscriberContext(ctx -> ctx.put((Object)REQUEST_TIMESTAMP_KEY, (Object)Instant.now().toEpochMilli()));
    }

    private static <T> WriterStrategy<T> cast(WriterStrategy<?> strategy) {
        return strategy;
    }

    private static <T> ReaderStrategy<T> cast(ReaderStrategy<?> strategy) {
        return strategy;
    }

    private static ClientException clientException(ClientRequest request, HttpClientResponse response, @Nullable ErrorResponse errorResponse) {
        return new ClientException(request, response, errorResponse);
    }

    private static RuntimeException noWriterException(@Nullable Object body, String contentType) {
        return new RuntimeException("No strategies to write this request: " + body + " - " + contentType);
    }

    private static RuntimeException noReaderException(Object body, String contentType) {
        return new RuntimeException("No strategies to read this response: " + body + " - " + contentType);
    }
}

