/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.route;

import discord4j.common.annotations.Experimental;
import discord4j.common.json.GuildEmojiResponse;
import discord4j.common.json.GuildMemberResponse;
import discord4j.common.json.MessageResponse;
import discord4j.common.json.RoleResponse;
import discord4j.common.json.UserResponse;
import discord4j.rest.json.response.ApplicationInfoResponse;
import discord4j.rest.json.response.AuditLogResponse;
import discord4j.rest.json.response.BanResponse;
import discord4j.rest.json.response.ChannelResponse;
import discord4j.rest.json.response.ConnectionResponse;
import discord4j.rest.json.response.GatewayResponse;
import discord4j.rest.json.response.GuildEmbedResponse;
import discord4j.rest.json.response.GuildResponse;
import discord4j.rest.json.response.IntegrationResponse;
import discord4j.rest.json.response.InviteResponse;
import discord4j.rest.json.response.NicknameModifyResponse;
import discord4j.rest.json.response.PruneResponse;
import discord4j.rest.json.response.UserGuildResponse;
import discord4j.rest.json.response.VoiceRegionResponse;
import discord4j.rest.json.response.WebhookResponse;
import discord4j.rest.route.Route;

public abstract class Routes {
    public static final String BASE_URL = "https://discordapp.com/api/v6";
    public static final Route<GatewayResponse> GATEWAY_GET = Route.get("/gateway", GatewayResponse.class);
    public static final Route<GatewayResponse> GATEWAY_BOT_GET = Route.get("/gateway/bot", GatewayResponse.class);
    public static final Route<AuditLogResponse> AUDIT_LOG_GET = Route.get("/guilds/{guild.id}/audit-logs", AuditLogResponse.class);
    public static final Route<ChannelResponse> CHANNEL_GET = Route.get("/channels/{channel.id}", ChannelResponse.class);
    public static final Route<ChannelResponse> CHANNEL_MODIFY = Route.put("/channels/{channel.id}", ChannelResponse.class);
    public static final Route<ChannelResponse> CHANNEL_MODIFY_PARTIAL = Route.patch("/channels/{channel.id}", ChannelResponse.class);
    public static final Route<ChannelResponse> CHANNEL_DELETE = Route.delete("/channels/{channel.id}", ChannelResponse.class);
    public static final Route<MessageResponse[]> MESSAGES_GET = Route.get("/channels/{channel.id}/messages", MessageResponse[].class);
    public static final Route<MessageResponse> MESSAGE_GET = Route.get("/channels/{channel.id}/messages/{message.id}", MessageResponse.class);
    public static final Route<MessageResponse> MESSAGE_CREATE = Route.post("/channels/{channel.id}/messages", MessageResponse.class);
    public static final Route<Void> REACTION_CREATE = Route.put("/channels/{channel.id}/messages/{message.id}/reactions/{emoji}/@me", Void.class);
    public static final Route<Void> REACTION_DELETE_OWN = Route.delete("/channels/{channel.id}/messages/{message.id}/reactions/{emoji}/@me", Void.class);
    public static final Route<Void> REACTION_DELETE = Route.delete("/channels/{channel.id}/messages/{message.id}/reactions/{emoji}/{user.id}", Void.class);
    public static final Route<UserResponse[]> REACTIONS_GET = Route.get("/channels/{channel.id}/messages/{message.id}/reactions/{emoji}", UserResponse[].class);
    public static final Route<Void> REACTIONS_DELETE_ALL = Route.delete("/channels/{channel.id}/messages/{message.id}/reactions", Void.class);
    public static final Route<MessageResponse> MESSAGE_EDIT = Route.patch("/channels/{channel.id}/messages/{message.id}", MessageResponse.class);
    public static final Route<Void> MESSAGE_DELETE = Route.delete("/channels/{channel.id}/messages/{message.id}", Void.class);
    public static final Route<Void> MESSAGE_DELETE_BULK = Route.post("/channels/{channel.id}/messages/bulk-delete", Void.class);
    @Experimental
    public static final Route<Void> MESSAGE_SUPPRESS_EMBEDS = Route.post("/channels/{channel.id}/messages/{message.id}/suppress-embeds", Void.class);
    public static final Route<Void> CHANNEL_PERMISSIONS_EDIT = Route.put("/channels/{channel.id}/permissions/{overwrite.id}", Void.class);
    public static final Route<InviteResponse[]> CHANNEL_INVITES_GET = Route.get("/channels/{channel.id}/invites", InviteResponse[].class);
    public static final Route<InviteResponse> CHANNEL_INVITE_CREATE = Route.post("/channels/{channel.id}/invites", InviteResponse.class);
    public static final Route<Void> CHANNEL_PERMISSION_DELETE = Route.delete("/channels/{channel.id}/permissions/{overwrite.id}", Void.class);
    public static final Route<Void> TYPING_INDICATOR_TRIGGER = Route.post("/channels/{channel.id}/typing", Void.class);
    public static final Route<MessageResponse[]> MESSAGES_PINNED_GET = Route.get("/channels/{channel.id}/pins", MessageResponse[].class);
    public static final Route<Void> MESSAGES_PINNED_ADD = Route.put("/channels/{channel.id}/pins/{message.id}", Void.class);
    public static final Route<Void> MESSAGES_PINNED_DELETE = Route.delete("/channels/{channel.id}/pins/{message.id}", Void.class);
    public static final Route<Void> GROUP_DM_RECIPIENT_ADD = Route.put("/channels/{channel.id}/recipients/{user.id}", Void.class);
    public static final Route<Void> GROUP_DM_RECIPIENT_DELETE = Route.delete("/channels/{channel.id}/recipients/{user.id}", Void.class);
    public static final Route<GuildEmojiResponse[]> GUILD_EMOJIS_GET = Route.get("/guilds/{guild.id}/emojis", GuildEmojiResponse[].class);
    public static final Route<GuildEmojiResponse> GUILD_EMOJI_GET = Route.get("/guilds/{guild.id}/emojis/{emoji.id}", GuildEmojiResponse.class);
    public static final Route<GuildEmojiResponse> GUILD_EMOJI_CREATE = Route.post("/guilds/{guild.id}/emojis", GuildEmojiResponse.class);
    public static final Route<GuildEmojiResponse> GUILD_EMOJI_MODIFY = Route.patch("/guilds/{guild.id}/emojis/{emoji.id}", GuildEmojiResponse.class);
    public static final Route<Void> GUILD_EMOJI_DELETE = Route.delete("/guilds/{guild.id}/emojis/{emoji.id}", Void.class);
    public static final Route<GuildResponse> GUILD_CREATE = Route.post("/guilds", GuildResponse.class);
    public static final Route<GuildResponse> GUILD_GET = Route.get("/guilds/{guild.id}", GuildResponse.class);
    public static final Route<GuildResponse> GUILD_MODIFY = Route.patch("/guilds/{guild.id}", GuildResponse.class);
    public static final Route<Void> GUILD_DELETE = Route.delete("/guilds/{guild.id}", Void.class);
    public static final Route<ChannelResponse[]> GUILD_CHANNELS_GET = Route.get("/guilds/{guild.id}/channels", ChannelResponse[].class);
    public static final Route<ChannelResponse> GUILD_CHANNEL_CREATE = Route.post("/guilds/{guild.id}/channels", ChannelResponse.class);
    public static final Route<RoleResponse[]> GUILD_CHANNEL_POSITIONS_MODIFY = Route.patch("/guilds/{guild.id}/channels", RoleResponse[].class);
    public static final Route<GuildMemberResponse> GUILD_MEMBER_GET = Route.get("/guilds/{guild.id}/members/{user.id}", GuildMemberResponse.class);
    public static final Route<GuildMemberResponse[]> GUILD_MEMBERS_LIST = Route.get("/guilds/{guild.id}/members", GuildMemberResponse[].class);
    public static final Route<GuildMemberResponse> GUILD_MEMBER_ADD = Route.put("/guilds/{guild.id}/members/{user.id}", GuildMemberResponse.class);
    public static final Route<Void> GUILD_MEMBER_MODIFY = Route.patch("/guilds/{guild.id}/members/{user.id}", Void.class);
    public static final Route<NicknameModifyResponse> NICKNAME_MODIFY_OWN = Route.patch("/guilds/{guild.id}/members/@me/nick", NicknameModifyResponse.class);
    public static final Route<Void> GUILD_MEMBER_ROLE_ADD = Route.put("/guilds/{guild.id}/members/{user.id}/roles/{role.id}", Void.class);
    public static final Route<Void> GUILD_MEMBER_ROLE_REMOVE = Route.delete("/guilds/{guild.id}/members/{user.id}/roles/{role.id}", Void.class);
    public static final Route<Void> GUILD_MEMBER_REMOVE = Route.delete("/guilds/{guild.id}/members/{user.id}", Void.class);
    public static final Route<BanResponse[]> GUILD_BANS_GET = Route.get("/guilds/{guild.id}/bans", BanResponse[].class);
    public static final Route<BanResponse> GUILD_BAN_GET = Route.get("/guilds/{guild.id}/bans/{user.id}", BanResponse.class);
    public static final Route<Void> GUILD_BAN_CREATE = Route.put("/guilds/{guild.id}/bans/{user.id}", Void.class);
    public static final Route<Void> GUILD_BAN_REMOVE = Route.delete("/guilds/{guild.id}/bans/{user.id}", Void.class);
    public static final Route<RoleResponse[]> GUILD_ROLES_GET = Route.get("/guilds/{guild.id}/roles", RoleResponse[].class);
    public static final Route<RoleResponse> GUILD_ROLE_CREATE = Route.post("/guilds/{guild.id}/roles", RoleResponse.class);
    public static final Route<RoleResponse[]> GUILD_ROLE_POSITIONS_MODIFY = Route.patch("/guilds/{guild.id}/roles", RoleResponse[].class);
    public static final Route<RoleResponse> GUILD_ROLE_MODIFY = Route.patch("/guilds/{guild.id}/roles/{role.id}", RoleResponse.class);
    public static final Route<Void> GUILD_ROLE_DELETE = Route.delete("/guilds/{guild.id}/roles/{role.id}", Void.class);
    public static final Route<PruneResponse> GUILD_PRUNE_COUNT_GET = Route.get("/guilds/{guild.id}/prune", PruneResponse.class);
    public static final Route<PruneResponse> GUILD_PRUNE_BEGIN = Route.post("/guilds/{guild.id}/prune", PruneResponse.class);
    public static final Route<VoiceRegionResponse[]> GUILD_VOICE_REGIONS_GET = Route.get("/guilds/{guild.id}/regions", VoiceRegionResponse[].class);
    public static final Route<InviteResponse[]> GUILD_INVITES_GET = Route.get("/guilds/{guild.id}/invites", InviteResponse[].class);
    public static final Route<IntegrationResponse[]> GUILD_INTEGRATIONS_GET = Route.get("/guilds/{guild.id}/integrations", IntegrationResponse[].class);
    public static final Route<Void> GUILD_INTEGRATION_CREATE = Route.post("/guilds/{guild.id}/integrations", Void.class);
    public static final Route<Void> GUILD_INTEGRATION_MODIFY = Route.patch("/guilds/{guild.id}/integrations/{integration.id}", Void.class);
    public static final Route<Void> GUILD_INTEGRATION_DELETE = Route.delete("/guilds/{guild.id}/integrations/{integration.id}", Void.class);
    public static final Route<Void> GUILD_INTEGRATION_SYNC = Route.post("/guilds/{guild.id}/integrations/{integration.id}/sync", Void.class);
    public static final Route<GuildEmbedResponse> GUILD_EMBED_GET = Route.get("/guilds/{guild.id}/embed", GuildEmbedResponse.class);
    public static final Route<GuildEmbedResponse> GUILD_EMBED_MODIFY = Route.patch("/guilds/{guild.id}/embed", GuildEmbedResponse.class);
    public static final Route<InviteResponse> INVITE_GET = Route.get("/invites/{invite.code}", InviteResponse.class);
    public static final Route<InviteResponse> INVITE_DELETE = Route.delete("/invites/{invite.code}", InviteResponse.class);
    public static final Route<InviteResponse> INVITE_ACCEPT = Route.post("/invites/{invite.code}", InviteResponse.class);
    public static final Route<UserResponse> CURRENT_USER_GET = Route.get("/users/@me", UserResponse.class);
    public static final Route<UserResponse> USER_GET = Route.get("/users/{user.id}", UserResponse.class);
    public static final Route<UserResponse> CURRENT_USER_MODIFY = Route.patch("/users/@me", UserResponse.class);
    public static final Route<UserGuildResponse[]> CURRENT_USER_GUILDS_GET = Route.get("/users/@me/guilds", UserGuildResponse[].class);
    public static final Route<Void> GUILD_LEAVE = Route.delete("/users/@me/guilds/{guild.id}", Void.class);
    public static final Route<ChannelResponse[]> USER_DMS_GET = Route.get("/users/@me/channels", ChannelResponse[].class);
    public static final Route<ChannelResponse> USER_DM_CREATE = Route.post("/users/@me/channels", ChannelResponse.class);
    public static final Route<ChannelResponse> GROUP_DM_CREATE = Route.post("/users/@me/channels", ChannelResponse.class);
    public static final Route<ConnectionResponse[]> USER_CONNECTIONS_GET = Route.get("/users/@me/connections", ConnectionResponse[].class);
    public static final Route<VoiceRegionResponse[]> VOICE_REGION_LIST = Route.get("/voice/regions", VoiceRegionResponse[].class);
    public static final Route<WebhookResponse> CHANNEL_WEBHOOK_CREATE = Route.post("/channels/{channel.id}/webhooks", WebhookResponse.class);
    public static final Route<WebhookResponse[]> CHANNEL_WEBHOOKS_GET = Route.get("/channels/{channel.id}/webhooks", WebhookResponse[].class);
    public static final Route<WebhookResponse[]> GUILD_WEBHOOKS_GET = Route.get("/guilds/{guild.id}/webhooks", WebhookResponse[].class);
    public static final Route<WebhookResponse> WEBHOOK_GET = Route.get("/webhooks/{webhook.id}", WebhookResponse.class);
    public static final Route<WebhookResponse> WEBHOOK_TOKEN_GET = Route.get("/webhooks/{webhook.id}/{webhook.token}", WebhookResponse.class);
    public static final Route<WebhookResponse> WEBHOOK_MODIFY = Route.patch("/webhooks/{webhook.id}", WebhookResponse.class);
    public static final Route<WebhookResponse> WEBHOOK_TOKEN_MODIFY = Route.patch("/webhooks/{webhook.id}/{webhook.token}", WebhookResponse.class);
    public static final Route<Void> WEBHOOK_DELETE = Route.delete("/webhooks/{webhook.id}", Void.class);
    public static final Route<Void> WEBHOOK_TOKEN_DELETE = Route.delete("/webhooks/{webhook.id}/{webhook.token}", Void.class);
    public static final Route<Void> WEBHOOK_EXECUTE = Route.post("/webhooks/{webhook.id}/{webhook.token}", Void.class);
    public static final Route<Void> WEBHOOK_EXECUTE_SLACK = Route.post("/webhooks/{webhook.id}/{webhook.token}/slack", Void.class);
    public static final Route<Void> WEBHOOK_EXECUTE_GITHUB = Route.post("/webhooks/{webhook.id}/{webhook.token}/github", Void.class);
    public static final Route<ApplicationInfoResponse> APPLICATION_INFO_GET = Route.get("/oauth2/applications/@me", ApplicationInfoResponse.class);
}

