/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.rest.request.GlobalRateLimiter;
import java.time.Duration;
import java.util.concurrent.Semaphore;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class SemaphoreGlobalRateLimiter
implements GlobalRateLimiter {
    private final Semaphore outer;
    private final Semaphore inner = new Semaphore(1, true);
    private volatile long limitedUntil = 0L;

    public SemaphoreGlobalRateLimiter(int parallelism) {
        this.outer = new Semaphore(parallelism, true);
    }

    @Override
    public void rateLimitFor(Duration duration) {
        this.limitedUntil = System.nanoTime() + duration.toNanos();
    }

    private Mono<Void> onComplete() {
        return Mono.defer(this::notifier);
    }

    private Mono<Void> notifier() {
        Duration remaining = this.getRemaining();
        if (!remaining.isNegative() && !remaining.isZero()) {
            return Mono.delay((Duration)remaining).then();
        }
        return Mono.empty();
    }

    @Override
    public Duration getRemaining() {
        return Duration.ofNanos(this.limitedUntil - System.nanoTime());
    }

    @Override
    public <T> Flux<T> withLimiter(Publisher<T> stage) {
        return Flux.usingWhen(this.acquire(), resource -> stage, this::release, this::release);
    }

    private Mono<Resource> acquire() {
        return Mono.fromCallable(() -> {
            this.outer.acquireUninterruptibly();
            Duration remaining = this.getRemaining();
            if (!remaining.isNegative() && !remaining.isZero()) {
                this.inner.acquireUninterruptibly();
                return new Resource(this.outer, this.inner);
            }
            return new Resource(this.outer, null);
        }).subscribeOn(Schedulers.elastic()).delayUntil(resource -> this.onComplete());
    }

    private Mono<Void> release(Resource resource) {
        return Mono.fromRunnable(() -> {
            if (resource.inner != null) {
                resource.inner.release();
            }
            if (resource.outer != null) {
                resource.outer.release();
            }
        });
    }

    static class Resource {
        private final Semaphore outer;
        private final Semaphore inner;

        Resource(Semaphore outer, Semaphore inner) {
            this.outer = outer;
            this.inner = inner;
        }
    }
}

