/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.json.request;

import discord4j.common.jackson.Possible;
import discord4j.common.jackson.PossibleJson;
import discord4j.common.jackson.PossibleLong;

@PossibleJson
public class RoleModifyRequest {
    private final Possible<String> name;
    private final PossibleLong permissions;
    private final Possible<Integer> color;
    private final Possible<Boolean> hoist;
    private final Possible<Boolean> mentionable;

    public RoleModifyRequest(Possible<String> name, PossibleLong permissions, Possible<Integer> color, Possible<Boolean> hoist, Possible<Boolean> mentionable) {
        this.name = name;
        this.permissions = permissions;
        this.color = color;
        this.hoist = hoist;
        this.mentionable = mentionable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "RoleModifyRequest{name=" + this.name + ", permissions=" + this.permissions + ", color=" + this.color + ", hoist=" + this.hoist + ", mentionable=" + this.mentionable + '}';
    }

    public static class Builder {
        private Possible<String> name = Possible.absent();
        private PossibleLong permissions = PossibleLong.absent();
        private Possible<Integer> color = Possible.absent();
        private Possible<Boolean> hoist = Possible.absent();
        private Possible<Boolean> mentionable = Possible.absent();

        public Builder name(String name) {
            this.name = Possible.of((Object)name);
            return this;
        }

        public Builder permissions(long permissions) {
            this.permissions = PossibleLong.of((long)permissions);
            return this;
        }

        public Builder color(int color) {
            this.color = Possible.of((Object)color);
            return this;
        }

        public Builder hoist(boolean hoist) {
            this.hoist = Possible.of((Object)hoist);
            return this;
        }

        public Builder mentionable(boolean mentionable) {
            this.mentionable = Possible.of((Object)mentionable);
            return this;
        }

        public RoleModifyRequest build() {
            return new RoleModifyRequest(this.name, this.permissions, this.color, this.hoist, this.mentionable);
        }
    }
}

