/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import discord4j.rest.http.ReaderStrategy;
import java.io.IOException;
import java.lang.reflect.Type;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class JacksonReaderStrategy<Res>
implements ReaderStrategy<Res> {
    private static final Logger log = Loggers.getLogger(JacksonReaderStrategy.class);
    private final ObjectMapper objectMapper;

    public JacksonReaderStrategy(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canRead(@Nullable Class<?> type, @Nullable String contentType) {
        if (type == null || contentType == null || !contentType.startsWith("application/json")) {
            return false;
        }
        return !CharSequence.class.isAssignableFrom(type) && this.objectMapper.canDeserialize(this.getJavaType(type));
    }

    @Override
    public Mono<Res> read(ByteBufMono content, Class<Res> responseType) {
        return content.asByteArray().map(bytes -> {
            try {
                return this.objectMapper.readValue(bytes, responseType);
            }
            catch (JsonProcessingException e) {
                throw Exceptions.propagate((Throwable)new RuntimeException(e.toString().replaceAll("(\"token\": \")([A-Za-z0-9.-]*)(\")", "$1hunter2$3")));
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }).doOnNext(response -> {
            if (log.isTraceEnabled()) {
                try {
                    log.trace("{}", new Object[]{this.objectMapper.writeValueAsString(response)});
                }
                catch (JsonProcessingException e) {
                    log.trace("Error while printing debug response: {}", new Object[]{response, e});
                }
            }
        });
    }

    private JavaType getJavaType(Type type) {
        return this.objectMapper.getTypeFactory().constructType(type);
    }
}

