/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http;

import discord4j.rest.http.ReaderStrategy;
import discord4j.rest.json.response.ErrorResponse;
import io.netty.util.IllegalReferenceCountException;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.util.annotation.Nullable;

public class FallbackReaderStrategy
implements ReaderStrategy<Object> {
    @Override
    public boolean canRead(@Nullable Class<?> type, @Nullable String contentType) {
        return true;
    }

    @Override
    public Mono<Object> read(ByteBufMono content, Class<Object> responseType) {
        if (ErrorResponse.class.isAssignableFrom(responseType)) {
            return content.asString().map(body -> {
                ErrorResponse response = new ErrorResponse();
                response.getFields().put("body", body);
                return response;
            });
        }
        return content.handle((buf, sink) -> {
            try {
                sink.next((Object)buf.readCharSequence(buf.readableBytes(), StandardCharsets.UTF_8).toString());
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }
}

