/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class RouteUtils {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\{([\\w.]+)}");
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    private RouteUtils() {
    }

    public static String expand(String template, Object ... variables) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = PARAMETER_PATTERN.matcher(template);
        int index = 0;
        while (matcher.find()) {
            matcher.appendReplacement(buf, RouteUtils.encodeUriComponent(variables[index++].toString(), Type.PATH_SEGMENT));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public static String expandQuery(String uri, @Nullable Map<String, ?> values) {
        if (values != null && !uri.contains("?")) {
            uri = uri + "?" + values.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).map(queryParam -> RouteUtils.encodeUriComponent(queryParam, Type.QUERY)).collect(Collectors.joining("&"));
        }
        return uri;
    }

    @Nullable
    public static String getMajorParam(String template, String complete) {
        if (template.contains("{channel.id}") || template.contains("{guild.id}") || template.contains("{webhook.id}")) {
            int start = template.indexOf(123);
            if (start == -1) {
                return null;
            }
            int end = complete.indexOf(47, start);
            if (end == -1) {
                end = complete.length();
            }
            return complete.substring(start, end);
        }
        return null;
    }

    private static String encodeUriComponent(@Nullable String source, Type type) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        byte[] bytes = source.getBytes(UTF_8);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        boolean changed = false;
        for (byte b : bytes) {
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (type.isAllowed(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
            changed = true;
        }
        return changed ? new String(bos.toByteArray(), UTF_8) : source;
    }

    static enum Type {
        PATH{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c;
            }
        }
        ,
        PATH_SEGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c);
            }
        }
        ,
        QUERY{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        QUERY_PARAM{

            @Override
            public boolean isAllowed(int c) {
                if (61 == c || 38 == c) {
                    return false;
                }
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        };


        public abstract boolean isAllowed(int var1);

        protected boolean isAlpha(int c) {
            return c >= 97 && c <= 122 || c >= 65 && c <= 90;
        }

        protected boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }

        protected boolean isGenericDelimiter(int c) {
            return 58 == c || 47 == c || 63 == c || 35 == c || 91 == c || 93 == c || 64 == c;
        }

        protected boolean isSubDelimiter(int c) {
            return 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
        }

        protected boolean isReserved(int c) {
            return this.isGenericDelimiter(c) || this.isSubDelimiter(c);
        }

        protected boolean isUnreserved(int c) {
            return this.isAlpha(c) || this.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
        }

        protected boolean isPchar(int c) {
            return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
        }
    }
}

