/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.rest.json.request.WebhookCreateRequest;
import discord4j.rest.json.request.WebhookModifyRequest;
import discord4j.rest.json.response.WebhookResponse;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class WebhookService
extends RestService {
    public WebhookService(Router router) {
        super(router);
    }

    public Mono<WebhookResponse> createWebhook(long channelId, WebhookCreateRequest request, @Nullable String reason) {
        return Routes.CHANNEL_WEBHOOK_CREATE.newRequest(channelId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter());
    }

    public Flux<WebhookResponse> getChannelWebhooks(long channelId) {
        return Routes.CHANNEL_WEBHOOKS_GET.newRequest(channelId).exchange(this.getRouter()).flatMapMany(Flux::fromArray);
    }

    public Flux<WebhookResponse> getGuildWebhooks(long guildId) {
        return Routes.GUILD_WEBHOOKS_GET.newRequest(guildId).exchange(this.getRouter()).flatMapMany(Flux::fromArray);
    }

    public Mono<WebhookResponse> getWebhook(long webhookId) {
        return Routes.WEBHOOK_GET.newRequest(webhookId).exchange(this.getRouter());
    }

    public Mono<WebhookResponse> modifyWebhook(long webhookId, WebhookModifyRequest request, @Nullable String reason) {
        return Routes.WEBHOOK_MODIFY.newRequest(webhookId).body(request).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter());
    }

    public Mono<Void> deleteWebhook(long webhookId, @Nullable String reason) {
        return Routes.WEBHOOK_DELETE.newRequest(webhookId).optionalHeader("X-Audit-Log-Reason", reason).exchange(this.getRouter());
    }
}

