/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.route;

import discord4j.rest.request.DiscordRequest;
import discord4j.rest.util.RouteUtils;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class Route<T> {
    private final HttpMethod method;
    private final String uriTemplate;
    private final Class<T> responseType;

    private Route(HttpMethod method, String uriTemplate, Class<T> responseType) {
        this.method = method;
        this.uriTemplate = uriTemplate;
        this.responseType = responseType;
    }

    public static <T> Route<T> get(String uri, Class<T> responseType) {
        return new Route<T>(HttpMethod.GET, uri, responseType);
    }

    public static <T> Route<T> post(String uri, Class<T> responseType) {
        return new Route<T>(HttpMethod.POST, uri, responseType);
    }

    public static <T> Route<T> put(String uri, Class<T> responseType) {
        return new Route<T>(HttpMethod.PUT, uri, responseType);
    }

    public static <T> Route<T> patch(String uri, Class<T> responseType) {
        return new Route<T>(HttpMethod.PATCH, uri, responseType);
    }

    public static <T> Route<T> delete(String uri, Class<T> responseType) {
        return new Route<T>(HttpMethod.DELETE, uri, responseType);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Class<T> getResponseType() {
        return this.responseType;
    }

    public DiscordRequest<T> newRequest(Object ... uriVars) {
        return new DiscordRequest(this, RouteUtils.expand(this.getUriTemplate(), uriVars));
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public int hashCode() {
        return Objects.hash(this.method, this.responseType, this.uriTemplate);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().isAssignableFrom(Route.class)) {
            return false;
        }
        Route other = (Route)obj;
        return other.method.equals((Object)this.method) && other.responseType.equals(this.responseType) && other.uriTemplate.equals(this.uriTemplate);
    }

    public String toString() {
        return "Route{method=" + this.method + ", uriTemplate='" + this.uriTemplate + '\'' + ", responseType=" + this.responseType + '}';
    }
}

