/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import java.time.Duration;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class GlobalRateLimiter {
    private static final Logger log = Loggers.getLogger(GlobalRateLimiter.class);
    private static final Object PERMIT = new Object();
    private final EmitterProcessor<Object> resetNotifier = EmitterProcessor.create((boolean)false);
    private volatile boolean isRateLimited;
    private final Flux<Void> flux = Flux.create(sink -> sink.onRequest(l -> {
        if (this.isRateLimited) {
            this.resetNotifier.next().subscribe(o -> sink.complete(), t -> log.error("Could not reset global notifier", t));
        } else {
            sink.complete();
        }
    }));

    void rateLimitFor(Duration duration) {
        if (log.isTraceEnabled()) {
            log.trace("Setting a global rate limit for {}", new Object[]{duration});
        }
        this.isRateLimited = true;
        Mono.delay((Duration)duration).subscribe(l -> {
            if (log.isTraceEnabled()) {
                log.trace("Global rate limit has completed after {}", new Object[]{duration});
            }
            this.isRateLimited = false;
            this.resetNotifier.onNext(PERMIT);
        }, t -> log.error("Error while resolving global rate limiter", t));
    }

    public Mono<Void> onComplete() {
        return this.flux.then();
    }
}

