/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.rest.request.Router;
import discord4j.rest.route.Route;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class DiscordRequest<T> {
    private final Route<T> route;
    private final String completeUri;
    @Nullable
    private Object body;
    @Nullable
    private Map<String, Object> queryParams;
    @Nullable
    private Map<String, Set<String>> headers;

    public DiscordRequest(Route<T> route, String completeUri) {
        this.route = route;
        this.completeUri = completeUri;
    }

    Route<T> getRoute() {
        return this.route;
    }

    String getCompleteUri() {
        return this.completeUri;
    }

    @Nullable
    public Object getBody() {
        return this.body;
    }

    @Nullable
    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    @Nullable
    public Map<String, Set<String>> getHeaders() {
        return this.headers;
    }

    public DiscordRequest<T> body(Object body) {
        this.body = body;
        return this;
    }

    public DiscordRequest<T> query(String key, Object value) {
        if (this.queryParams == null) {
            this.queryParams = new LinkedHashMap<String, Object>();
        }
        this.queryParams.put(key, value);
        return this;
    }

    public DiscordRequest<T> query(Map<String, Object> params) {
        params.forEach(this::query);
        return this;
    }

    public DiscordRequest<T> header(String key, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, Set<String>>();
        }
        this.headers.computeIfAbsent(key.toLowerCase(), k -> new LinkedHashSet()).add(value);
        return this;
    }

    public DiscordRequest<T> optionalHeader(String key, @Nullable String value) {
        return value == null ? this : this.header(key, value);
    }

    public Mono<T> exchange(Router router) {
        return router.exchange(this);
    }

    public String toString() {
        return "DiscordRequest{route=" + this.route + ", completeUri='" + this.completeUri + '\'' + ", body=" + this.body + ", queryParams=" + this.queryParams + ", headers=" + this.headers + '}';
    }
}

