/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http.client;

import discord4j.rest.http.client.ClientRequest;
import discord4j.rest.json.response.ErrorResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import reactor.netty.http.client.HttpClientResponse;
import reactor.util.annotation.Nullable;

public class ClientException
extends RuntimeException {
    private final ClientRequest request;
    private final HttpResponseStatus status;
    private final HttpHeaders headers;
    private final ErrorResponse errorResponse;

    public ClientException(ClientRequest request, HttpClientResponse response, @Nullable ErrorResponse errorResponse) {
        super(request.method().toString() + " " + request.url() + " returned " + response.status().toString() + (errorResponse != null ? " with response " + errorResponse.getFields() : ""));
        this.request = request;
        this.status = response.status();
        this.headers = response.responseHeaders();
        this.errorResponse = errorResponse;
    }

    public ClientRequest getRequest() {
        return this.request;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Nullable
    public ErrorResponse getErrorResponse() {
        return this.errorResponse;
    }

    @Override
    public String toString() {
        return "ClientException{request=" + this.request + ", status=" + this.status + ", headers=" + this.headers.copy().remove((CharSequence)HttpHeaderNames.AUTHORIZATION).toString() + ", errorResponse=" + this.errorResponse + "}";
    }
}

