/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import discord4j.rest.http.WriterStrategy;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.util.annotation.Nullable;

public class JacksonWriterStrategy
implements WriterStrategy<Object> {
    private final ObjectMapper objectMapper;

    public JacksonWriterStrategy(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canWrite(@Nullable Class<?> type, @Nullable String contentType) {
        if (type == null || contentType == null || !contentType.startsWith("application/json")) {
            return false;
        }
        Class rawClass = this.getJavaType(type).getRawClass();
        return Object.class == rawClass || !String.class.isAssignableFrom(rawClass) && this.objectMapper.canSerialize(rawClass);
    }

    @Override
    public Mono<HttpClient.ResponseReceiver<?>> write(HttpClient.RequestSender sender, @Nullable Object body) {
        if (body == null) {
            return Mono.error((Throwable)new RuntimeException("Missing body"));
        }
        try {
            return Mono.just((Object)sender.send((Publisher)ByteBufFlux.fromString((Publisher)Mono.just((Object)this.objectMapper.writeValueAsString(body)), (Charset)StandardCharsets.UTF_8, (ByteBufAllocator)ByteBufAllocator.DEFAULT)));
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private JavaType getJavaType(Type type) {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        return typeFactory.constructType(type);
    }
}

