/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.state;

import discord4j.common.store.Store;
import discord4j.common.store.action.gateway.GatewayActions;
import discord4j.common.store.api.StoreAction;
import discord4j.common.store.api.object.InvalidationCause;
import discord4j.discordjson.json.gateway.ChannelCreate;
import discord4j.discordjson.json.gateway.ChannelDelete;
import discord4j.discordjson.json.gateway.ChannelUpdate;
import discord4j.discordjson.json.gateway.Dispatch;
import discord4j.discordjson.json.gateway.GuildCreate;
import discord4j.discordjson.json.gateway.GuildDelete;
import discord4j.discordjson.json.gateway.GuildEmojisUpdate;
import discord4j.discordjson.json.gateway.GuildMemberAdd;
import discord4j.discordjson.json.gateway.GuildMemberRemove;
import discord4j.discordjson.json.gateway.GuildMemberUpdate;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.GuildRoleCreate;
import discord4j.discordjson.json.gateway.GuildRoleDelete;
import discord4j.discordjson.json.gateway.GuildRoleUpdate;
import discord4j.discordjson.json.gateway.GuildScheduledEventCreate;
import discord4j.discordjson.json.gateway.GuildScheduledEventDelete;
import discord4j.discordjson.json.gateway.GuildScheduledEventUpdate;
import discord4j.discordjson.json.gateway.GuildScheduledEventUserAdd;
import discord4j.discordjson.json.gateway.GuildScheduledEventUserRemove;
import discord4j.discordjson.json.gateway.GuildStickersUpdate;
import discord4j.discordjson.json.gateway.GuildUpdate;
import discord4j.discordjson.json.gateway.MessageCreate;
import discord4j.discordjson.json.gateway.MessageDelete;
import discord4j.discordjson.json.gateway.MessageDeleteBulk;
import discord4j.discordjson.json.gateway.MessageReactionAdd;
import discord4j.discordjson.json.gateway.MessageReactionRemove;
import discord4j.discordjson.json.gateway.MessageReactionRemoveAll;
import discord4j.discordjson.json.gateway.MessageReactionRemoveEmoji;
import discord4j.discordjson.json.gateway.MessageUpdate;
import discord4j.discordjson.json.gateway.PresenceUpdate;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.discordjson.json.gateway.ThreadCreate;
import discord4j.discordjson.json.gateway.ThreadDelete;
import discord4j.discordjson.json.gateway.ThreadListSync;
import discord4j.discordjson.json.gateway.ThreadMemberUpdate;
import discord4j.discordjson.json.gateway.ThreadMembersUpdate;
import discord4j.discordjson.json.gateway.ThreadUpdate;
import discord4j.discordjson.json.gateway.UserUpdate;
import discord4j.discordjson.json.gateway.VoiceStateUpdateDispatch;
import discord4j.gateway.ShardInfo;
import discord4j.gateway.json.ShardAwareDispatch;
import discord4j.gateway.retry.GatewayStateChange;
import discord4j.gateway.state.StatefulDispatch;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class DispatchStoreLayer {
    private static final Logger log = Loggers.getLogger(DispatchStoreLayer.class);
    private static final Set<DispatchToAction> DISPATCH_TO_ACTION = new HashSet<DispatchToAction>();
    private final Store store;
    private final ShardInfo shardInfo;

    private DispatchStoreLayer(Store store, ShardInfo shardInfo) {
        this.store = store;
        this.shardInfo = shardInfo;
    }

    public static DispatchStoreLayer create(Store store, ShardInfo shardInfo) {
        Objects.requireNonNull(store);
        Objects.requireNonNull(shardInfo);
        return new DispatchStoreLayer(store, shardInfo);
    }

    private static <D extends Dispatch> void add(Predicate<? super Dispatch> predicate, BiFunction<Integer, D, StoreAction<?>> actionFactory) {
        DISPATCH_TO_ACTION.add(new DispatchToAction(predicate, (shard, dispatch) -> (StoreAction)actionFactory.apply((Integer)shard, (Object)dispatch)));
    }

    public Mono<StatefulDispatch<?, ?>> store(Dispatch dispatch) {
        Dispatch actualDispatch;
        ShardInfo shardInfo;
        Objects.requireNonNull(dispatch);
        if (dispatch instanceof ShardAwareDispatch) {
            ShardAwareDispatch shardAwareDispatch = (ShardAwareDispatch)dispatch;
            shardInfo = ShardInfo.create(shardAwareDispatch.getShardIndex(), shardAwareDispatch.getShardCount());
            actualDispatch = shardAwareDispatch.getDispatch();
        } else {
            shardInfo = this.shardInfo;
            actualDispatch = dispatch;
        }
        return Flux.fromStream(DISPATCH_TO_ACTION.stream().filter(entry -> ((DispatchToAction)entry).predicate.test(actualDispatch)).map(entry -> ((DispatchToAction)entry).actionFactory)).singleOrEmpty().map(actionFactory -> (StoreAction)actionFactory.apply(shardInfo.getIndex(), actualDispatch)).flatMap(action -> Mono.from((Publisher)this.store.execute(action))).map(oldState -> StatefulDispatch.of(shardInfo, actualDispatch, oldState)).onErrorResume(t -> Mono.fromRunnable(() -> log.error("Error when executing store action on dispatch " + dispatch, t))).defaultIfEmpty(StatefulDispatch.of(shardInfo, actualDispatch, null));
    }

    static {
        DispatchStoreLayer.add(ChannelCreate.class::isInstance, GatewayActions::channelCreate);
        DispatchStoreLayer.add(ChannelDelete.class::isInstance, GatewayActions::channelDelete);
        DispatchStoreLayer.add(ChannelUpdate.class::isInstance, GatewayActions::channelUpdate);
        DispatchStoreLayer.add(GuildCreate.class::isInstance, GatewayActions::guildCreate);
        DispatchStoreLayer.add(GuildDelete.class::isInstance, GatewayActions::guildDelete);
        DispatchStoreLayer.add(GuildStickersUpdate.class::isInstance, GatewayActions::guildStickersUpdate);
        DispatchStoreLayer.add(GuildEmojisUpdate.class::isInstance, GatewayActions::guildEmojisUpdate);
        DispatchStoreLayer.add(GuildMemberAdd.class::isInstance, GatewayActions::guildMemberAdd);
        DispatchStoreLayer.add(GuildMemberRemove.class::isInstance, GatewayActions::guildMemberRemove);
        DispatchStoreLayer.add(GuildMembersChunk.class::isInstance, GatewayActions::guildMembersChunk);
        DispatchStoreLayer.add(GuildMemberUpdate.class::isInstance, GatewayActions::guildMemberUpdate);
        DispatchStoreLayer.add(GuildRoleCreate.class::isInstance, GatewayActions::guildRoleCreate);
        DispatchStoreLayer.add(GuildRoleDelete.class::isInstance, GatewayActions::guildRoleDelete);
        DispatchStoreLayer.add(GuildRoleUpdate.class::isInstance, GatewayActions::guildRoleUpdate);
        DispatchStoreLayer.add(GuildScheduledEventCreate.class::isInstance, GatewayActions::guildScheduledEventCreate);
        DispatchStoreLayer.add(GuildScheduledEventUpdate.class::isInstance, GatewayActions::guildScheduledEventUpdate);
        DispatchStoreLayer.add(GuildScheduledEventDelete.class::isInstance, GatewayActions::guildScheduledEventDelete);
        DispatchStoreLayer.add(GuildScheduledEventUserAdd.class::isInstance, GatewayActions::guildScheduledEventUserAdd);
        DispatchStoreLayer.add(GuildScheduledEventUserRemove.class::isInstance, GatewayActions::guildScheduledEventUserRemove);
        DispatchStoreLayer.add(GuildUpdate.class::isInstance, GatewayActions::guildUpdate);
        DispatchStoreLayer.add(ThreadCreate.class::isInstance, GatewayActions::threadCreate);
        DispatchStoreLayer.add(ThreadUpdate.class::isInstance, GatewayActions::threadUpdate);
        DispatchStoreLayer.add(ThreadDelete.class::isInstance, GatewayActions::threadDelete);
        DispatchStoreLayer.add(ThreadListSync.class::isInstance, GatewayActions::threadListSync);
        DispatchStoreLayer.add(ThreadMemberUpdate.class::isInstance, GatewayActions::threadMemberUpdate);
        DispatchStoreLayer.add(ThreadMembersUpdate.class::isInstance, GatewayActions::threadMembersUpdate);
        DispatchStoreLayer.add(MessageCreate.class::isInstance, GatewayActions::messageCreate);
        DispatchStoreLayer.add(MessageDelete.class::isInstance, GatewayActions::messageDelete);
        DispatchStoreLayer.add(MessageDeleteBulk.class::isInstance, GatewayActions::messageDeleteBulk);
        DispatchStoreLayer.add(MessageReactionAdd.class::isInstance, GatewayActions::messageReactionAdd);
        DispatchStoreLayer.add(MessageReactionRemove.class::isInstance, GatewayActions::messageReactionRemove);
        DispatchStoreLayer.add(MessageReactionRemoveAll.class::isInstance, GatewayActions::messageReactionRemoveAll);
        DispatchStoreLayer.add(MessageReactionRemoveEmoji.class::isInstance, GatewayActions::messageReactionRemoveEmoji);
        DispatchStoreLayer.add(MessageUpdate.class::isInstance, GatewayActions::messageUpdate);
        DispatchStoreLayer.add(PresenceUpdate.class::isInstance, GatewayActions::presenceUpdate);
        DispatchStoreLayer.add(Ready.class::isInstance, (shard, dispatch) -> GatewayActions.ready((Ready)dispatch));
        DispatchStoreLayer.add(UserUpdate.class::isInstance, GatewayActions::userUpdate);
        DispatchStoreLayer.add(VoiceStateUpdateDispatch.class::isInstance, GatewayActions::voiceStateUpdateDispatch);
        DispatchStoreLayer.add(dispatch -> dispatch instanceof GatewayStateChange && ((GatewayStateChange)dispatch).getState() == GatewayStateChange.State.DISCONNECTED, (shard, dispatch) -> GatewayActions.invalidateShard((int)shard, (InvalidationCause)InvalidationCause.LOGOUT));
        DispatchStoreLayer.add(dispatch -> dispatch instanceof GatewayStateChange && ((GatewayStateChange)dispatch).getState() == GatewayStateChange.State.SESSION_INVALIDATED, (shard, dispatch) -> GatewayActions.invalidateShard((int)shard, (InvalidationCause)InvalidationCause.HARD_RECONNECT));
    }

    private static class DispatchToAction {
        private final Predicate<? super Dispatch> predicate;
        private final BiFunction<Integer, Dispatch, StoreAction<?>> actionFactory;

        private DispatchToAction(Predicate<? super Dispatch> predicate, BiFunction<Integer, Dispatch, StoreAction<?>> actionFactory) {
            this.predicate = predicate;
            this.actionFactory = actionFactory;
        }
    }
}

