/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.retry;

import discord4j.common.close.CloseStatus;
import discord4j.common.close.DisconnectBehavior;
import discord4j.discordjson.json.gateway.Dispatch;
import discord4j.gateway.retry.ClosingStateChange;
import java.time.Duration;
import reactor.util.annotation.Nullable;

public class GatewayStateChange
implements Dispatch {
    private final State state;
    private final long currentAttempt;
    private final Duration backoff;

    public static GatewayStateChange connected() {
        return new GatewayStateChange(State.CONNECTED, 0L, null);
    }

    public static ClosingStateChange disconnected(DisconnectBehavior behavior, CloseStatus status) {
        return new ClosingStateChange(behavior, status);
    }

    public static GatewayStateChange disconnectedResume() {
        return new GatewayStateChange(State.DISCONNECTED_RESUME, 0L, null);
    }

    public static GatewayStateChange retryStarted(Duration nextAttemptBackoff) {
        return new GatewayStateChange(State.RETRY_STARTED, 1L, nextAttemptBackoff);
    }

    public static GatewayStateChange retryStartedResume(Duration nextAttemptBackoff) {
        return new GatewayStateChange(State.RETRY_RESUME_STARTED, 1L, nextAttemptBackoff);
    }

    public static GatewayStateChange retrySucceeded(long currentAttempt) {
        return new GatewayStateChange(State.RETRY_SUCCEEDED, currentAttempt, null);
    }

    public static GatewayStateChange retryFailed(long currentAttempt, Duration nextAttemptBackoff) {
        return new GatewayStateChange(State.RETRY_FAILED, currentAttempt, nextAttemptBackoff);
    }

    protected GatewayStateChange(State state, long currentAttempt, @Nullable Duration backoff) {
        this.state = state;
        this.currentAttempt = currentAttempt;
        this.backoff = backoff;
    }

    public State getState() {
        return this.state;
    }

    public long getCurrentAttempt() {
        return this.currentAttempt;
    }

    @Nullable
    public Duration getBackoff() {
        return this.backoff;
    }

    public String toString() {
        return "GatewayStateChanged[state=" + (Object)((Object)this.state) + ", currentAttempt=" + this.currentAttempt + ", backoff=" + this.backoff + ']';
    }

    public static enum State {
        CONNECTED,
        DISCONNECTED,
        DISCONNECTED_RESUME,
        RETRY_STARTED,
        RETRY_RESUME_STARTED,
        RETRY_SUCCEEDED,
        RETRY_FAILED;

    }
}

