/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import discord4j.common.LogUtil;
import discord4j.discordjson.json.gateway.Dispatch;
import discord4j.discordjson.json.gateway.Heartbeat;
import discord4j.discordjson.json.gateway.Hello;
import discord4j.discordjson.json.gateway.Identify;
import discord4j.discordjson.json.gateway.IdentifyProperties;
import discord4j.discordjson.json.gateway.ImmutableHeartbeat;
import discord4j.discordjson.json.gateway.ImmutableIdentify;
import discord4j.discordjson.json.gateway.ImmutableIdentifyProperties;
import discord4j.discordjson.json.gateway.ImmutableResume;
import discord4j.discordjson.json.gateway.InvalidSession;
import discord4j.discordjson.json.gateway.Opcode;
import discord4j.discordjson.json.gateway.PayloadData;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.discordjson.json.gateway.Resume;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.DefaultGatewayClient;
import discord4j.gateway.GatewayConnection;
import discord4j.gateway.IdentifyOptions;
import discord4j.gateway.PayloadContext;
import discord4j.gateway.PayloadHandler;
import discord4j.gateway.json.GatewayPayload;
import discord4j.gateway.retry.InvalidSessionException;
import discord4j.gateway.retry.ReconnectException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

public abstract class PayloadHandlers {
    private static final Logger log = Loggers.getLogger(PayloadHandlers.class);
    private static final Map<Opcode<?>, PayloadHandler<?>> handlerMap = new HashMap();

    private static <T extends PayloadData> void addHandler(Opcode<T> op, PayloadHandler<T> handler) {
        handlerMap.put(op, handler);
    }

    public static <T extends PayloadData> Mono<Void> handle(PayloadContext<T> context) {
        PayloadHandler<?> handler = handlerMap.get(context.getPayload().getOp());
        if (handler == null) {
            log.warn("Handler not found from: {}", new Object[]{context.getPayload()});
            return Mono.empty();
        }
        return Mono.defer(() -> handler.handle(context)).checkpoint("Dispatch handled for OP " + context.getPayload().getOp().getRawOp() + " seq " + context.getPayload().getSequence() + " type " + context.getPayload().getType());
    }

    private static Mono<Void> handleDispatch(PayloadContext<Dispatch> context) {
        if (context.getData() instanceof Ready) {
            String newSessionId = ((Ready)context.getData()).sessionId();
            context.getClient().sessionId().set(newSessionId);
        }
        if (context.getData() != null) {
            context.getClient().dispatchSink().next((Object)context.getData());
        }
        return Mono.empty();
    }

    private static Mono<Void> handleHeartbeat(PayloadContext<Heartbeat> context) {
        log.debug(LogUtil.format((Context)context.getContext(), (String)"Received heartbeat"));
        context.getClient().sender().next(GatewayPayload.heartbeat((Heartbeat)ImmutableHeartbeat.of((int)context.getClient().sequence().get())));
        return Mono.empty();
    }

    private static Mono<Void> handleReconnect(PayloadContext<?> context) {
        context.getHandler().error(new ReconnectException(context.getContext(), "Reconnecting due to reconnect packet received"));
        return Mono.empty();
    }

    private static Mono<Void> handleInvalidSession(PayloadContext<InvalidSession> context) {
        DefaultGatewayClient client = context.getClient();
        if (context.getData().resumable()) {
            String token = client.token();
            client.sender().next(GatewayPayload.resume((Resume)ImmutableResume.of((String)token, (String)client.getSessionId(), (int)client.sequence().get())));
        } else {
            context.getHandler().error(new InvalidSessionException(context.getContext(), "Reconnecting due to non-resumable session invalidation"));
        }
        return Mono.empty();
    }

    private static Mono<Void> handleHello(PayloadContext<Hello> context) {
        Duration interval = Duration.ofMillis(context.getData().heartbeatInterval());
        DefaultGatewayClient client = context.getClient();
        client.heartbeat().start(Duration.ZERO, interval);
        return client.stateEvents().next().doOnNext(state -> {
            if (state == GatewayConnection.State.START_RESUMING || state == GatewayConnection.State.RESUMING) {
                PayloadHandlers.doResume(context);
            } else {
                PayloadHandlers.doIdentify(context);
            }
        }).then();
    }

    private static void doResume(PayloadContext<Hello> context) {
        DefaultGatewayClient client = context.getClient();
        log.debug(LogUtil.format((Context)context.getContext(), (String)"Resuming Gateway session from {}"), new Object[]{client.sequence().get()});
        client.sender().next(GatewayPayload.resume((Resume)ImmutableResume.of((String)client.token(), (String)client.getSessionId(), (int)client.sequence().get())));
    }

    private static void doIdentify(PayloadContext<Hello> context) {
        DefaultGatewayClient client = context.getClient();
        ImmutableIdentifyProperties props = ImmutableIdentifyProperties.of((String)System.getProperty("os.name"), (String)"Discord4J", (String)"Discord4J");
        IdentifyOptions options = client.identifyOptions();
        ImmutableIdentify identify = Identify.builder().token(client.token()).intents(options.getIntents().map(set -> Possible.of((Object)set.getRawValue())).orElse(Possible.absent())).properties((IdentifyProperties)props).compress(Boolean.valueOf(false)).largeThreshold(options.getLargeThreshold()).shard(options.getShardInfo().asArray()).presence(options.getInitialStatus().map(Possible::of).orElse(Possible.absent())).guildSubscriptions(options.getGuildSubscriptions().map(Possible::of).orElse(Possible.absent())).build();
        log.debug(LogUtil.format((Context)context.getContext(), (String)"Identifying to Gateway"), new Object[]{client.sequence().get()});
        client.sender().next(GatewayPayload.identify((Identify)identify));
    }

    private static Mono<Void> handleHeartbeatAck(PayloadContext<?> context) {
        context.getClient().ackHeartbeat();
        log.debug(LogUtil.format((Context)context.getContext(), (String)"Heartbeat acknowledged after {}"), new Object[]{context.getClient().getResponseTime()});
        return Mono.empty();
    }

    static {
        PayloadHandlers.addHandler(Opcode.DISPATCH, PayloadHandlers::handleDispatch);
        PayloadHandlers.addHandler(Opcode.HEARTBEAT, PayloadHandlers::handleHeartbeat);
        PayloadHandlers.addHandler(Opcode.RECONNECT, PayloadHandlers::handleReconnect);
        PayloadHandlers.addHandler(Opcode.INVALID_SESSION, PayloadHandlers::handleInvalidSession);
        PayloadHandlers.addHandler(Opcode.HELLO, PayloadHandlers::handleHello);
        PayloadHandlers.addHandler(Opcode.HEARTBEAT_ACK, PayloadHandlers::handleHeartbeatAck);
    }
}

