/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import discord4j.discordjson.json.gateway.StatusUpdate;
import discord4j.gateway.SessionInfo;
import discord4j.gateway.ShardInfo;
import discord4j.gateway.intent.IntentSet;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class IdentifyOptions {
    private final ShardInfo shardInfo;
    @Nullable
    private final StatusUpdate initialStatus;
    @Nullable
    private final IntentSet intents;
    @Nullable
    private final Boolean guildSubscriptions;
    private final int largeThreshold;
    @Nullable
    private final SessionInfo resumeSession;

    protected IdentifyOptions(Builder builder) {
        this.shardInfo = builder.shardInfo;
        this.initialStatus = builder.initialStatus;
        this.intents = builder.intents;
        this.guildSubscriptions = builder.guildSubscriptions;
        this.largeThreshold = builder.largeThreshold;
        this.resumeSession = builder.resumeSession;
    }

    public static IdentifyOptions create(int shardIndex, int shardCount) {
        return IdentifyOptions.builder(ShardInfo.create(shardIndex, shardCount)).build();
    }

    public static IdentifyOptions create(ShardInfo shardInfo) {
        return IdentifyOptions.builder(shardInfo).build();
    }

    public static Builder builder(int shardIndex, int shardCount) {
        return new Builder(ShardInfo.create(shardIndex, shardCount));
    }

    public static Builder builder(ShardInfo shardInfo) {
        return new Builder(shardInfo);
    }

    public Builder mutate() {
        return new Builder(this.shardInfo).initialStatus(this.initialStatus).intents(this.intents).guildSubscriptions(this.guildSubscriptions).largeThreshold(this.largeThreshold).resumeSession(this.resumeSession);
    }

    public Builder mutate(ShardInfo shardInfo) {
        return new Builder(shardInfo).initialStatus(this.initialStatus).intents(this.intents).guildSubscriptions(this.guildSubscriptions).largeThreshold(this.largeThreshold).resumeSession(this.resumeSession);
    }

    public ShardInfo getShardInfo() {
        return this.shardInfo;
    }

    public Optional<StatusUpdate> getInitialStatus() {
        return Optional.ofNullable(this.initialStatus);
    }

    public Optional<IntentSet> getIntents() {
        return Optional.ofNullable(this.intents);
    }

    public Optional<Boolean> getGuildSubscriptions() {
        return Optional.ofNullable(this.guildSubscriptions);
    }

    public int getLargeThreshold() {
        return this.largeThreshold;
    }

    public Optional<SessionInfo> getResumeSession() {
        return Optional.ofNullable(this.resumeSession);
    }

    public String toString() {
        return "IdentifyOptions{shardInfo=" + this.shardInfo + ", initialStatus=" + this.initialStatus + ", intents=" + this.intents + ", guildSubscriptions=" + this.guildSubscriptions + ", largeThreshold=" + this.largeThreshold + ", resumeSession=" + this.resumeSession + '}';
    }

    public static class Builder {
        private final ShardInfo shardInfo;
        private StatusUpdate initialStatus;
        private IntentSet intents;
        private Boolean guildSubscriptions;
        private int largeThreshold = 250;
        private SessionInfo resumeSession;

        protected Builder(ShardInfo shardInfo) {
            this.shardInfo = ShardInfo.create(shardInfo.getIndex(), shardInfo.getCount());
        }

        public Builder initialStatus(@Nullable StatusUpdate initialStatus) {
            this.initialStatus = initialStatus;
            return this;
        }

        public Builder intents(@Nullable IntentSet intents) {
            this.intents = intents;
            return this;
        }

        public Builder guildSubscriptions(@Nullable Boolean guildSubscriptions) {
            this.guildSubscriptions = guildSubscriptions;
            return this;
        }

        public Builder largeThreshold(int largeThreshold) {
            this.largeThreshold = largeThreshold;
            return this;
        }

        public Builder resumeSession(@Nullable SessionInfo resumeSession) {
            this.resumeSession = resumeSession;
            return this;
        }

        public IdentifyOptions build() {
            return new IdentifyOptions(this);
        }
    }
}

