/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.intent;

import discord4j.gateway.intent.Intent;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;

public final class IntentSet
extends AbstractSet<Intent> {
    private static final long ALL_RAW = Arrays.stream(Intent.values()).mapToLong(Intent::getValue).reduce((a, b) -> a | b).orElseThrow(AssertionError::new);
    private static final long NONE_RAW = 0L;
    private static final IntentSet ALL = new IntentSet(ALL_RAW);
    private static final IntentSet NONE = new IntentSet(0L);
    private final long rawValue;

    public static IntentSet all() {
        return ALL;
    }

    public static IntentSet none() {
        return NONE;
    }

    public static IntentSet of(long rawValue) {
        return new IntentSet(rawValue);
    }

    public static IntentSet of(Intent ... intents) {
        long rawValue = Arrays.stream(intents).mapToLong(Intent::getValue).reduce(0L, (left, right) -> left | right);
        return new IntentSet(rawValue);
    }

    private IntentSet(long rawValue) {
        this.rawValue = rawValue;
    }

    public IntentSet and(IntentSet other) {
        return IntentSet.of(this.rawValue & other.rawValue);
    }

    public IntentSet or(IntentSet other) {
        return IntentSet.of(this.rawValue | other.rawValue);
    }

    public IntentSet xor(IntentSet other) {
        return IntentSet.of(this.rawValue ^ other.rawValue);
    }

    public IntentSet andNot(IntentSet other) {
        return IntentSet.of(this.rawValue & (other.rawValue ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public IntentSet not() {
        return IntentSet.of((this.rawValue ^ 0xFFFFFFFFFFFFFFFFL) & ALL_RAW);
    }

    public EnumSet<Intent> asEnumSet() {
        EnumSet<Intent> intents = EnumSet.allOf(Intent.class);
        intents.removeIf(intent -> !this.contains(intent));
        return intents;
    }

    public long getRawValue() {
        return this.rawValue;
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Intent && ((long)((Intent)((Object)o)).getValue() & this.rawValue) > 0L;
    }

    @Override
    public Iterator<Intent> iterator() {
        return Collections.unmodifiableSet(this.asEnumSet()).iterator();
    }

    @Override
    public int size() {
        return Long.bitCount(this.rawValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntentSet that = (IntentSet)o;
        return this.rawValue == that.rawValue;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.rawValue);
    }

    @Override
    public String toString() {
        return "IntentSet{rawValue=" + this.rawValue + "} " + super.toString();
    }
}

