/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Predicate;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public class ZlibDecompressor {
    private static final int ZLIB_SUFFIX = 65535;
    private static final Predicate<ByteBuf> windowPredicate = payload -> payload.readableBytes() >= 4 && payload.getInt(payload.readableBytes() - 4) == 65535;
    private final ByteBufAllocator allocator;
    private final Inflater context = new Inflater();

    public ZlibDecompressor(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    public Flux<ByteBuf> completeMessages(Flux<ByteBuf> payloads) {
        return payloads.windowUntil(windowPredicate).flatMap(Flux::collectList).map(list -> {
            ByteBuf buf;
            if (list.size() == 1) {
                buf = (ByteBuf)list.get(0);
            } else {
                CompositeByteBuf composite = this.allocator.compositeBuffer(list.size());
                for (ByteBuf component : list) {
                    composite.addComponent(true, component);
                }
                buf = composite;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (InflaterOutputStream inflater = new InflaterOutputStream(out, this.context);){
                inflater.write(ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)buf.readableBytes(), (boolean)false));
                ByteBuf byteBuf = this.allocator.buffer().writeBytes(out.toByteArray()).asReadOnly();
                return byteBuf;
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }
}

