/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import discord4j.discordjson.json.gateway.Dispatch;
import discord4j.gateway.GatewayConnection;
import discord4j.gateway.json.GatewayPayload;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public interface GatewayClient {
    public Mono<Void> execute(String var1);

    public Mono<Void> close(boolean var1);

    public Flux<Dispatch> dispatch();

    public Flux<GatewayPayload<?>> receiver();

    public <T> Flux<T> receiver(Function<ByteBuf, Publisher<? extends T>> var1);

    public FluxSink<GatewayPayload<?>> sender();

    default public Mono<Void> send(Publisher<? extends GatewayPayload<?>> publisher) {
        return Flux.from(publisher).doOnNext(payload -> this.sender().next(payload)).then();
    }

    public Mono<Void> sendBuffer(Publisher<ByteBuf> var1);

    public int getShardCount();

    public String getSessionId();

    public int getSequence();

    public Flux<GatewayConnection.State> stateEvents();

    public Mono<Boolean> isConnected();

    public Duration getResponseTime();
}

