/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.retry;

import discord4j.gateway.json.dispatch.Dispatch;
import java.time.Duration;
import reactor.util.annotation.Nullable;

public class GatewayStateChange
implements Dispatch {
    private final State state;
    private final int currentAttempt;
    private final Duration backoff;

    public static GatewayStateChange connected() {
        return new GatewayStateChange(State.CONNECTED, 0, null);
    }

    public static GatewayStateChange disconnected() {
        return new GatewayStateChange(State.DISCONNECTED, 0, null);
    }

    public static GatewayStateChange retryStarted(Duration nextAttemptBackoff) {
        return new GatewayStateChange(State.RETRY_STARTED, 1, nextAttemptBackoff);
    }

    public static GatewayStateChange retrySucceeded(int currentAttempt) {
        return new GatewayStateChange(State.RETRY_SUCCEEDED, currentAttempt, null);
    }

    public static GatewayStateChange retryFailed(int currentAttempt, Duration nextAttemptBackoff) {
        return new GatewayStateChange(State.RETRY_FAILED, currentAttempt, nextAttemptBackoff);
    }

    private GatewayStateChange(State state, int currentAttempt, @Nullable Duration backoff) {
        this.state = state;
        this.currentAttempt = currentAttempt;
        this.backoff = backoff;
    }

    public State getState() {
        return this.state;
    }

    public int getCurrentAttempt() {
        return this.currentAttempt;
    }

    @Nullable
    public Duration getBackoff() {
        return this.backoff;
    }

    public String toString() {
        return "GatewayStateChanged[state=" + (Object)((Object)this.state) + ", currentAttempt=" + this.currentAttempt + ", backoff=" + this.backoff + ']';
    }

    public static enum State {
        CONNECTED,
        DISCONNECTED,
        RETRY_STARTED,
        RETRY_SUCCEEDED,
        RETRY_FAILED;

    }
}

