/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import discord4j.gateway.json.GatewayPayload;
import discord4j.gateway.json.Opcode;
import discord4j.gateway.json.PayloadData;
import discord4j.gateway.json.dispatch.ChannelCreate;
import discord4j.gateway.json.dispatch.ChannelDelete;
import discord4j.gateway.json.dispatch.ChannelPinsUpdate;
import discord4j.gateway.json.dispatch.ChannelUpdate;
import discord4j.gateway.json.dispatch.Dispatch;
import discord4j.gateway.json.dispatch.GuildBanAdd;
import discord4j.gateway.json.dispatch.GuildBanRemove;
import discord4j.gateway.json.dispatch.GuildCreate;
import discord4j.gateway.json.dispatch.GuildDelete;
import discord4j.gateway.json.dispatch.GuildEmojisUpdate;
import discord4j.gateway.json.dispatch.GuildIntegrationsUpdate;
import discord4j.gateway.json.dispatch.GuildMemberAdd;
import discord4j.gateway.json.dispatch.GuildMemberRemove;
import discord4j.gateway.json.dispatch.GuildMemberUpdate;
import discord4j.gateway.json.dispatch.GuildMembersChunk;
import discord4j.gateway.json.dispatch.GuildRoleCreate;
import discord4j.gateway.json.dispatch.GuildRoleDelete;
import discord4j.gateway.json.dispatch.GuildRoleUpdate;
import discord4j.gateway.json.dispatch.GuildUpdate;
import discord4j.gateway.json.dispatch.MessageCreate;
import discord4j.gateway.json.dispatch.MessageDelete;
import discord4j.gateway.json.dispatch.MessageDeleteBulk;
import discord4j.gateway.json.dispatch.MessageReactionAdd;
import discord4j.gateway.json.dispatch.MessageReactionRemove;
import discord4j.gateway.json.dispatch.MessageReactionRemoveAll;
import discord4j.gateway.json.dispatch.MessageUpdate;
import discord4j.gateway.json.dispatch.PresenceUpdate;
import discord4j.gateway.json.dispatch.Ready;
import discord4j.gateway.json.dispatch.Resumed;
import discord4j.gateway.json.dispatch.TypingStart;
import discord4j.gateway.json.dispatch.UserUpdate;
import discord4j.gateway.json.dispatch.VoiceServerUpdate;
import discord4j.gateway.json.dispatch.VoiceStateUpdateDispatch;
import discord4j.gateway.json.dispatch.WebhooksUpdate;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public class PayloadDeserializer
extends StdDeserializer<GatewayPayload<?>> {
    private static final String OP_FIELD = "op";
    private static final String D_FIELD = "d";
    private static final String T_FIELD = "t";
    private static final String S_FIELD = "s";
    private static final Map<String, Class<? extends Dispatch>> dispatchTypes = new HashMap<String, Class<? extends Dispatch>>();

    public PayloadDeserializer() {
        super(GatewayPayload.class);
    }

    public GatewayPayload<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode payload = (JsonNode)p.getCodec().readTree(p);
        int op = payload.get(OP_FIELD).asInt();
        String t = payload.get(T_FIELD).asText();
        Integer s = payload.get(S_FIELD).isNull() ? null : Integer.valueOf(payload.get(S_FIELD).intValue());
        Class<? extends PayloadData> payloadType = PayloadDeserializer.getPayloadType(op, t);
        PayloadData data = payloadType == null ? null : (PayloadData)p.getCodec().treeToValue((TreeNode)payload.get(D_FIELD), payloadType);
        return new GatewayPayload<PayloadData>(Opcode.forRaw(op), data, s, t);
    }

    @Nullable
    private static Class<? extends PayloadData> getPayloadType(int op, String t) {
        if (op == Opcode.DISPATCH.getRawOp()) {
            if (!dispatchTypes.containsKey(t)) {
                throw new IllegalArgumentException("Attempt to deserialize payload with unknown event type: " + t);
            }
            return dispatchTypes.get(t);
        }
        Opcode<?> opcode = Opcode.forRaw(op);
        if (opcode == null) {
            throw new IllegalArgumentException("Attempt to deserialize payload with unknown op: " + op);
        }
        return opcode.getPayloadType();
    }

    static {
        dispatchTypes.put("READY", Ready.class);
        dispatchTypes.put("RESUMED", Resumed.class);
        dispatchTypes.put("CHANNEL_CREATE", ChannelCreate.class);
        dispatchTypes.put("CHANNEL_UPDATE", ChannelUpdate.class);
        dispatchTypes.put("CHANNEL_DELETE", ChannelDelete.class);
        dispatchTypes.put("CHANNEL_PINS_UPDATE", ChannelPinsUpdate.class);
        dispatchTypes.put("GUILD_CREATE", GuildCreate.class);
        dispatchTypes.put("GUILD_UPDATE", GuildUpdate.class);
        dispatchTypes.put("GUILD_DELETE", GuildDelete.class);
        dispatchTypes.put("GUILD_BAN_ADD", GuildBanAdd.class);
        dispatchTypes.put("GUILD_BAN_REMOVE", GuildBanRemove.class);
        dispatchTypes.put("GUILD_EMOJIS_UPDATE", GuildEmojisUpdate.class);
        dispatchTypes.put("GUILD_INTEGRATIONS_UPDATE", GuildIntegrationsUpdate.class);
        dispatchTypes.put("GUILD_MEMBER_ADD", GuildMemberAdd.class);
        dispatchTypes.put("GUILD_MEMBER_REMOVE", GuildMemberRemove.class);
        dispatchTypes.put("GUILD_MEMBER_UPDATE", GuildMemberUpdate.class);
        dispatchTypes.put("GUILD_MEMBERS_CHUNK", GuildMembersChunk.class);
        dispatchTypes.put("GUILD_ROLE_CREATE", GuildRoleCreate.class);
        dispatchTypes.put("GUILD_ROLE_UPDATE", GuildRoleUpdate.class);
        dispatchTypes.put("GUILD_ROLE_DELETE", GuildRoleDelete.class);
        dispatchTypes.put("MESSAGE_CREATE", MessageCreate.class);
        dispatchTypes.put("MESSAGE_UPDATE", MessageUpdate.class);
        dispatchTypes.put("MESSAGE_DELETE", MessageDelete.class);
        dispatchTypes.put("MESSAGE_DELETE_BULK", MessageDeleteBulk.class);
        dispatchTypes.put("MESSAGE_REACTION_ADD", MessageReactionAdd.class);
        dispatchTypes.put("MESSAGE_REACTION_REMOVE", MessageReactionRemove.class);
        dispatchTypes.put("MESSAGE_REACTION_REMOVE_ALL", MessageReactionRemoveAll.class);
        dispatchTypes.put("PRESENCE_UPDATE", PresenceUpdate.class);
        dispatchTypes.put("TYPING_START", TypingStart.class);
        dispatchTypes.put("USER_UPDATE", UserUpdate.class);
        dispatchTypes.put("VOICE_STATE_UPDATE", VoiceStateUpdateDispatch.class);
        dispatchTypes.put("VOICE_SERVER_UPDATE", VoiceServerUpdate.class);
        dispatchTypes.put("WEBHOOKS_UPDATE", WebhooksUpdate.class);
        dispatchTypes.put("PRESENCES_REPLACE", null);
    }
}

