/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.json;

import discord4j.gateway.json.Heartbeat;
import discord4j.gateway.json.Hello;
import discord4j.gateway.json.Identify;
import discord4j.gateway.json.InvalidSession;
import discord4j.gateway.json.PayloadData;
import discord4j.gateway.json.RequestGuildMembers;
import discord4j.gateway.json.Resume;
import discord4j.gateway.json.StatusUpdate;
import discord4j.gateway.json.VoiceStateUpdate;
import discord4j.gateway.json.dispatch.Dispatch;
import reactor.util.annotation.Nullable;

public final class Opcode<T extends PayloadData> {
    public static final Opcode<Dispatch> DISPATCH = Opcode.newOp(0, Dispatch.class);
    public static final Opcode<Heartbeat> HEARTBEAT = Opcode.newOp(1, Heartbeat.class);
    public static final Opcode<Identify> IDENTIFY = Opcode.newOp(2, Identify.class);
    public static final Opcode<StatusUpdate> STATUS_UPDATE = Opcode.newOp(3, StatusUpdate.class);
    public static final Opcode<VoiceStateUpdate> VOICE_STATE_UPDATE = Opcode.newOp(4, VoiceStateUpdate.class);
    public static final Opcode<?> VOICE_SERVER_PING = Opcode.newOp(5, null);
    public static final Opcode<Resume> RESUME = Opcode.newOp(6, Resume.class);
    public static final Opcode<?> RECONNECT = Opcode.newOp(7, null);
    public static final Opcode<RequestGuildMembers> REQUEST_GUILD_MEMBERS = Opcode.newOp(8, RequestGuildMembers.class);
    public static final Opcode<InvalidSession> INVALID_SESSION = Opcode.newOp(9, InvalidSession.class);
    public static final Opcode<Hello> HELLO = Opcode.newOp(10, Hello.class);
    public static final Opcode<?> HEARTBEAT_ACK = Opcode.newOp(11, null);
    private final int rawOp;
    private final Class<T> payloadType;

    private Opcode(int rawOp, @Nullable Class<T> payloadType) {
        this.rawOp = rawOp;
        this.payloadType = payloadType;
    }

    @Nullable
    public static Opcode<?> forRaw(int rawOp) {
        switch (rawOp) {
            case 0: {
                return DISPATCH;
            }
            case 1: {
                return HEARTBEAT;
            }
            case 2: {
                return IDENTIFY;
            }
            case 3: {
                return STATUS_UPDATE;
            }
            case 4: {
                return VOICE_STATE_UPDATE;
            }
            case 5: {
                return VOICE_SERVER_PING;
            }
            case 6: {
                return RESUME;
            }
            case 7: {
                return RECONNECT;
            }
            case 8: {
                return REQUEST_GUILD_MEMBERS;
            }
            case 9: {
                return INVALID_SESSION;
            }
            case 10: {
                return HELLO;
            }
            case 11: {
                return HEARTBEAT_ACK;
            }
        }
        return null;
    }

    private static <T extends PayloadData> Opcode<T> newOp(int rawOp, @Nullable Class<T> payloadType) {
        return new Opcode<T>(rawOp, payloadType);
    }

    public int getRawOp() {
        return this.rawOp;
    }

    @Nullable
    public Class<T> getPayloadType() {
        return this.payloadType;
    }

    public String toString() {
        return Integer.toString(this.getRawOp());
    }
}

