/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Predicate;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public class ZlibDecompressor {
    private static final int ZLIB_SUFFIX = 65535;
    private static final Predicate<ByteBuf> windowPredicate = payload -> payload.readableBytes() >= 4 && payload.getInt(payload.readableBytes() - 4) == 65535;
    private final Inflater context = new Inflater();

    public Flux<ByteBuf> completeMessages(Flux<ByteBuf> payloads) {
        return payloads.windowUntil(windowPredicate).flatMap(Flux::collectList).map(list -> {
            ByteBuf buf = Unpooled.wrappedBuffer((ByteBuf[])list.toArray(new ByteBuf[0]));
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (InflaterOutputStream inflater = new InflaterOutputStream(out, this.context);){
                inflater.write(bytes);
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])out.toByteArray());
                return byteBuf;
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }
}

