/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.retry;

import discord4j.gateway.retry.RetryContext;
import java.time.Duration;
import reactor.core.scheduler.Scheduler;
import reactor.retry.Backoff;
import reactor.retry.BackoffDelay;
import reactor.retry.Jitter;

public class RetryOptions {
    private final RetryContext retryContext;
    private final int maxRetries;
    private final Scheduler backoffScheduler;

    public RetryOptions(Duration firstBackoff, Duration maxBackoffInterval, int maxRetries, Scheduler scheduler) {
        if (firstBackoff.minus(Duration.ofSeconds(2L)).isNegative()) {
            throw new IllegalArgumentException("firstBackoff duration must be at least 2 seconds");
        }
        if (maxBackoffInterval.minus(firstBackoff).isNegative()) {
            throw new IllegalArgumentException("maxBackoffInterval must be at least the same as firstBackoff");
        }
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries must be a positive integer");
        }
        this.retryContext = new RetryContext(firstBackoff, maxBackoffInterval);
        this.maxRetries = maxRetries;
        this.backoffScheduler = scheduler;
    }

    public RetryContext getRetryContext() {
        return this.retryContext;
    }

    public Backoff getBackoff() {
        return context -> {
            Duration nextBackoff;
            RetryContext appContext = (RetryContext)context.applicationContext();
            try {
                long factor = (long)Math.pow(2.0, appContext.getAttempts() - 1);
                nextBackoff = appContext.getFirstBackoff().multipliedBy(factor);
            }
            catch (ArithmeticException e) {
                nextBackoff = appContext.getMaxBackoffInterval();
            }
            return new BackoffDelay(appContext.getFirstBackoff(), appContext.getMaxBackoffInterval(), nextBackoff);
        };
    }

    public Jitter getJitter() {
        return Jitter.random();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Scheduler getBackoffScheduler() {
        return this.backoffScheduler;
    }
}

