/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.retry;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RetryContext {
    private final Duration firstBackoff;
    private final Duration maxBackoffInterval;
    private AtomicBoolean connected = new AtomicBoolean(false);
    private AtomicInteger attempts = new AtomicInteger(1);
    private AtomicInteger resetCount = new AtomicInteger(0);

    public RetryContext(Duration firstBackoff, Duration maxBackoffInterval) {
        this.firstBackoff = firstBackoff;
        this.maxBackoffInterval = maxBackoffInterval;
    }

    public void next() {
        this.connected.compareAndSet(true, false);
        this.attempts.incrementAndGet();
    }

    public void reset() {
        this.connected.compareAndSet(false, true);
        this.attempts.set(1);
        this.resetCount.incrementAndGet();
    }

    public void clear() {
        this.connected.compareAndSet(true, false);
        this.attempts.set(1);
        this.resetCount.set(0);
    }

    public Duration getFirstBackoff() {
        return this.firstBackoff;
    }

    public Duration getMaxBackoffInterval() {
        return this.maxBackoffInterval;
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public int getAttempts() {
        return this.attempts.get();
    }

    public int getResetCount() {
        return this.resetCount.get();
    }
}

