/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import discord4j.common.RateLimiter;
import discord4j.gateway.PayloadTransformer;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class RateLimiterTransformer
implements PayloadTransformer {
    private final RateLimiter limiter;

    public RateLimiterTransformer(RateLimiter limiter) {
        this.limiter = limiter;
    }

    @Override
    public Publisher<ByteBuf> apply(Flux<ByteBuf> publisher) {
        return publisher.concatMap(payload -> Mono.create(sink -> {
            if (this.limiter.tryConsume(1)) {
                sink.success(payload);
            } else {
                sink.error((Throwable)new RuntimeException());
            }
        }).retryWhen(errors -> errors.concatMap(t -> Mono.delay((Duration)Duration.ofMillis(this.limiter.delayMillisToConsume(1L)), (Scheduler)Schedulers.single()))), 1);
    }
}

