/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import discord4j.common.jackson.Possible;
import discord4j.gateway.DefaultGatewayClient;
import discord4j.gateway.IdentifyOptions;
import discord4j.gateway.PayloadContext;
import discord4j.gateway.PayloadHandler;
import discord4j.gateway.json.GatewayPayload;
import discord4j.gateway.json.Heartbeat;
import discord4j.gateway.json.Hello;
import discord4j.gateway.json.Identify;
import discord4j.gateway.json.IdentifyProperties;
import discord4j.gateway.json.InvalidSession;
import discord4j.gateway.json.Opcode;
import discord4j.gateway.json.PayloadData;
import discord4j.gateway.json.Resume;
import discord4j.gateway.json.StatusUpdate;
import discord4j.gateway.json.dispatch.Dispatch;
import discord4j.gateway.json.dispatch.Ready;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class PayloadHandlers {
    private static final Map<Opcode<?>, PayloadHandler<?>> handlerMap = new HashMap();

    private static <T extends PayloadData> void addHandler(Opcode<T> op, PayloadHandler<T> handler) {
        handlerMap.put(op, handler);
    }

    public static <T extends PayloadData> void handle(PayloadContext<T> context) {
        PayloadHandler<?> entry = handlerMap.get(context.getPayload().getOp());
        if (entry != null) {
            entry.handle(context);
        }
    }

    private static void handleDispatch(PayloadContext<Dispatch> context) {
        if (context.getData() instanceof Ready) {
            String newSessionId = ((Ready)context.getData()).getSessionId();
            context.getClient().sessionId().set(newSessionId);
        }
        if (context.getData() != null) {
            context.getClient().dispatchSink().next((Object)context.getData());
        }
    }

    private static void handleHeartbeat(PayloadContext<Heartbeat> context) {
        PayloadHandlers.log(context).debug("Received heartbeat");
        context.getClient().sender().next(GatewayPayload.heartbeat(new Heartbeat(context.getClient().sequence().get())));
    }

    private static void handleReconnect(PayloadContext<?> context) {
        context.getHandler().error(new RuntimeException("Reconnecting due to reconnect packet received"));
    }

    private static void handleInvalidSession(PayloadContext<InvalidSession> context) {
        DefaultGatewayClient client = context.getClient();
        if (context.getData().isResumable()) {
            String token = client.token();
            client.sender().next(GatewayPayload.resume(new Resume(token, client.getSessionId(), client.sequence().get())));
        } else {
            client.resumable().set(false);
            context.getHandler().error(new RuntimeException("Reconnecting due to non-resumable session invalidation"));
        }
    }

    private static void handleHello(PayloadContext<Hello> context) {
        Duration interval = Duration.ofMillis(context.getData().getHeartbeatInterval());
        DefaultGatewayClient client = context.getClient();
        client.heartbeat().start(interval);
        if (client.resumable().get()) {
            PayloadHandlers.log(context).info("Attempting to RESUME from {}", new Object[]{client.sequence().get()});
            client.sender().next(GatewayPayload.resume(new Resume(client.token(), client.getSessionId(), client.sequence().get())));
        } else {
            IdentifyProperties props = new IdentifyProperties(System.getProperty("os.name"), "Discord4J", "Discord4J");
            IdentifyOptions options = client.identifyOptions();
            int[] shard = new int[]{options.getShardIndex(), options.getShardCount()};
            Identify identify = new Identify(client.token(), props, false, 250, (Possible<int[]>)Optional.of(shard).map(Possible::of).orElse(Possible.absent()), (Possible<StatusUpdate>)Optional.ofNullable(options.getInitialStatus()).map(Possible::of).orElse(Possible.absent()));
            client.sender().next(GatewayPayload.identify(identify));
        }
    }

    private static void handleHeartbeatAck(PayloadContext<?> context) {
        context.getClient().ackHeartbeat();
        PayloadHandlers.log(context).debug("Heartbeat acknowledged after {} ms", new Object[]{context.getClient().getResponseTime()});
    }

    private static Logger log(PayloadContext<?> context) {
        return Loggers.getLogger((String)("discord4j.gateway.handler." + context.getClient().identifyOptions().getShardIndex()));
    }

    static {
        PayloadHandlers.addHandler(Opcode.DISPATCH, PayloadHandlers::handleDispatch);
        PayloadHandlers.addHandler(Opcode.HEARTBEAT, PayloadHandlers::handleHeartbeat);
        PayloadHandlers.addHandler(Opcode.RECONNECT, PayloadHandlers::handleReconnect);
        PayloadHandlers.addHandler(Opcode.INVALID_SESSION, PayloadHandlers::handleInvalidSession);
        PayloadHandlers.addHandler(Opcode.HELLO, PayloadHandlers::handleHello);
        PayloadHandlers.addHandler(Opcode.HEARTBEAT_ACK, PayloadHandlers::handleHeartbeatAck);
    }
}

