/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import discord4j.gateway.GatewayObserver;
import discord4j.gateway.json.GatewayPayload;
import discord4j.gateway.json.dispatch.Dispatch;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public interface GatewayClient {
    public Mono<Void> execute(String var1);

    public Mono<Void> execute(String var1, GatewayObserver var2);

    public Mono<Void> close(boolean var1);

    public Flux<Dispatch> dispatch();

    public Flux<GatewayPayload<?>> receiver();

    public <T> Flux<T> receiver(Function<ByteBuf, Publisher<? extends T>> var1);

    public FluxSink<GatewayPayload<?>> sender();

    default public Mono<Void> send(Publisher<GatewayPayload<?>> publisher) {
        return Flux.from(publisher).doOnNext(payload -> this.sender().next(payload)).then();
    }

    public Mono<Void> sendBuffer(Publisher<ByteBuf> var1);

    public String getSessionId();

    public int getSequence();

    public boolean isConnected();

    public long getResponseTime();
}

