/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.payload;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import discord4j.gateway.json.GatewayPayload;
import discord4j.gateway.payload.PayloadReader;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class JacksonPayloadReader
implements PayloadReader {
    private static final Logger log = Loggers.getLogger(JacksonPayloadReader.class);
    private final ObjectMapper mapper;
    private final boolean lenient;

    public JacksonPayloadReader(ObjectMapper mapper) {
        this(mapper, true);
    }

    public JacksonPayloadReader(ObjectMapper mapper, boolean lenient) {
        this.mapper = mapper;
        this.lenient = lenient;
    }

    public Mono<GatewayPayload<?>> read(ByteBuf payload) {
        return Mono.create(sink -> {
            try {
                GatewayPayload value = (GatewayPayload)this.mapper.readValue(payload.array(), new TypeReference<GatewayPayload<?>>(){});
                sink.success((Object)value);
            }
            catch (IOException | IllegalArgumentException e) {
                if (this.lenient) {
                    if (payload.readableBytes() > 0) {
                        log.debug("Error while decoding JSON ({}): {}", new Object[]{e.toString(), payload.toString(StandardCharsets.UTF_8)});
                    }
                    sink.success();
                }
                sink.error((Throwable)Exceptions.propagate((Throwable)e));
            }
        });
    }
}

