/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store.legacy;

import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildScheduledEventData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.PresenceData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.StageInstanceData;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.json.ThreadMemberData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.store.api.Store;
import discord4j.store.api.primitive.LongObjStore;
import discord4j.store.api.service.StoreService;
import discord4j.store.api.util.LongLongTuple2;
import discord4j.store.api.util.StoreContext;
import java.util.Collections;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class StateHolder {
    private static final Logger log = Loggers.getLogger(StateHolder.class);
    private final StoreService storeService;
    private final LongObjStore<ChannelData> channelStore;
    private final LongObjStore<GuildData> guildStore;
    private final Store<LongLongTuple2, GuildScheduledEventData> guildEventsStore;
    private final Store<LongLongTuple2, Set> guildEventsUsersStore;
    private final LongObjStore<EmojiData> guildEmojiStore;
    private final LongObjStore<StickerData> guildStickerStore;
    private final Store<LongLongTuple2, MemberData> memberStore;
    private final LongObjStore<MessageData> messageStore;
    private final Store<LongLongTuple2, PresenceData> presenceStore;
    private final LongObjStore<RoleData> roleStore;
    private final LongObjStore<StageInstanceData> stageInstanceStore;
    private final LongObjStore<UserData> userStore;
    private final Store<LongLongTuple2, VoiceStateData> voiceStateStore;
    private final Store<LongLongTuple2, ThreadMemberData> threadMemberStore;

    public StateHolder(StoreService service) {
        this.storeService = service;
        service.init(new StoreContext(Collections.singletonMap("messageClass", MessageData.class)));
        this.channelStore = service.provideLongObjStore(ChannelData.class);
        log.debug("Channel storage           : {}", new Object[]{this.channelStore});
        this.guildStore = service.provideLongObjStore(GuildData.class);
        log.debug("Guild storage             : {}", new Object[]{this.guildStore});
        this.guildStickerStore = service.provideLongObjStore(StickerData.class);
        log.debug("Guild sticker storage     : {}", new Object[]{this.guildStickerStore});
        this.guildEventsStore = service.provideGenericStore(LongLongTuple2.class, GuildScheduledEventData.class);
        log.debug("Guild event storage       : {}", new Object[]{this.guildEventsStore});
        this.guildEventsUsersStore = service.provideGenericStore(LongLongTuple2.class, Set.class);
        log.debug("Guild event users storage : {}", new Object[]{this.guildEventsUsersStore});
        this.guildEmojiStore = service.provideLongObjStore(EmojiData.class);
        log.debug("Guild emoji storage       : {}", new Object[]{this.guildEmojiStore});
        this.memberStore = service.provideGenericStore(LongLongTuple2.class, MemberData.class);
        log.debug("Member storage            : {}", new Object[]{this.memberStore});
        this.messageStore = service.provideLongObjStore(MessageData.class);
        log.debug("Message storage           : {}", new Object[]{this.messageStore});
        this.presenceStore = service.provideGenericStore(LongLongTuple2.class, PresenceData.class);
        log.debug("Presence storage          : {}", new Object[]{this.presenceStore});
        this.roleStore = service.provideLongObjStore(RoleData.class);
        log.debug("Role storage              : {}", new Object[]{this.roleStore});
        this.stageInstanceStore = service.provideLongObjStore(StageInstanceData.class);
        log.debug("StageInstance storage     : {}", new Object[]{this.stageInstanceStore});
        this.userStore = service.provideLongObjStore(UserData.class);
        log.debug("User storage              : {}", new Object[]{this.userStore});
        this.voiceStateStore = service.provideGenericStore(LongLongTuple2.class, VoiceStateData.class);
        log.debug("Voice state storage       : {}", new Object[]{this.voiceStateStore});
        this.threadMemberStore = service.provideGenericStore(LongLongTuple2.class, ThreadMemberData.class);
        log.debug("Thread member storage     : {}", new Object[]{this.voiceStateStore});
    }

    public StoreService getStoreService() {
        return this.storeService;
    }

    public LongObjStore<ChannelData> getChannelStore() {
        return this.channelStore;
    }

    public LongObjStore<GuildData> getGuildStore() {
        return this.guildStore;
    }

    public LongObjStore<StickerData> getGuildStickerStore() {
        return this.guildStickerStore;
    }

    public Store<LongLongTuple2, GuildScheduledEventData> getGuildEventsStore() {
        return this.guildEventsStore;
    }

    public Store<LongLongTuple2, Set> getGuildEventsUsersStore() {
        return this.guildEventsUsersStore;
    }

    public LongObjStore<EmojiData> getGuildEmojiStore() {
        return this.guildEmojiStore;
    }

    public Store<LongLongTuple2, MemberData> getMemberStore() {
        return this.memberStore;
    }

    public LongObjStore<MessageData> getMessageStore() {
        return this.messageStore;
    }

    public Store<LongLongTuple2, PresenceData> getPresenceStore() {
        return this.presenceStore;
    }

    public LongObjStore<RoleData> getRoleStore() {
        return this.roleStore;
    }

    public LongObjStore<StageInstanceData> getStageInstanceStore() {
        return this.stageInstanceStore;
    }

    public LongObjStore<UserData> getUserStore() {
        return this.userStore;
    }

    public Store<LongLongTuple2, VoiceStateData> getVoiceStateStore() {
        return this.voiceStateStore;
    }

    public Store<LongLongTuple2, ThreadMemberData> getThreadMemberStore() {
        return this.threadMemberStore;
    }

    public Mono<Void> invalidateStores() {
        return this.channelStore.invalidate().and((Publisher)this.guildStore.invalidate()).and((Publisher)this.guildEmojiStore.invalidate()).and((Publisher)this.guildEventsStore.invalidate()).and((Publisher)this.memberStore.invalidate()).and((Publisher)this.messageStore.invalidate()).and((Publisher)this.presenceStore.invalidate()).and((Publisher)this.roleStore.invalidate()).and((Publisher)this.stageInstanceStore.invalidate()).and((Publisher)this.userStore.invalidate()).and((Publisher)this.voiceStateStore.invalidate()).and((Publisher)this.threadMemberStore.invalidate());
    }
}

