/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store.legacy;

import discord4j.common.store.api.layout.DataAccessor;
import discord4j.common.store.api.layout.GatewayDataUpdater;
import discord4j.common.store.api.layout.StoreLayout;
import discord4j.common.store.api.object.InvalidationCause;
import discord4j.common.store.api.object.PresenceAndUserData;
import discord4j.common.store.legacy.ListUtil;
import discord4j.common.store.legacy.StateHolder;
import discord4j.common.util.Snowflake;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ClientStatusData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildCreateData;
import discord4j.discordjson.json.GuildCreateFields;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildScheduledEventData;
import discord4j.discordjson.json.GuildUpdateFields;
import discord4j.discordjson.json.ImmutableGuildData;
import discord4j.discordjson.json.ImmutableMemberData;
import discord4j.discordjson.json.ImmutableMessageData;
import discord4j.discordjson.json.ImmutablePresenceData;
import discord4j.discordjson.json.ImmutableReactionData;
import discord4j.discordjson.json.ImmutableUserData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.PartialMessageData;
import discord4j.discordjson.json.PartialStickerData;
import discord4j.discordjson.json.PartialUserData;
import discord4j.discordjson.json.PresenceData;
import discord4j.discordjson.json.ReactionData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.RoleDataFields;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.gateway.ChannelCreate;
import discord4j.discordjson.json.gateway.ChannelDelete;
import discord4j.discordjson.json.gateway.ChannelUpdate;
import discord4j.discordjson.json.gateway.GuildCreate;
import discord4j.discordjson.json.gateway.GuildDelete;
import discord4j.discordjson.json.gateway.GuildEmojisUpdate;
import discord4j.discordjson.json.gateway.GuildMemberAdd;
import discord4j.discordjson.json.gateway.GuildMemberRemove;
import discord4j.discordjson.json.gateway.GuildMemberUpdate;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.GuildRoleCreate;
import discord4j.discordjson.json.gateway.GuildRoleDelete;
import discord4j.discordjson.json.gateway.GuildRoleUpdate;
import discord4j.discordjson.json.gateway.GuildScheduledEventCreate;
import discord4j.discordjson.json.gateway.GuildScheduledEventDelete;
import discord4j.discordjson.json.gateway.GuildScheduledEventUpdate;
import discord4j.discordjson.json.gateway.GuildScheduledEventUserAdd;
import discord4j.discordjson.json.gateway.GuildScheduledEventUserRemove;
import discord4j.discordjson.json.gateway.GuildStickersUpdate;
import discord4j.discordjson.json.gateway.GuildUpdate;
import discord4j.discordjson.json.gateway.MessageCreate;
import discord4j.discordjson.json.gateway.MessageDelete;
import discord4j.discordjson.json.gateway.MessageDeleteBulk;
import discord4j.discordjson.json.gateway.MessageReactionAdd;
import discord4j.discordjson.json.gateway.MessageReactionRemove;
import discord4j.discordjson.json.gateway.MessageReactionRemoveAll;
import discord4j.discordjson.json.gateway.MessageReactionRemoveEmoji;
import discord4j.discordjson.json.gateway.MessageUpdate;
import discord4j.discordjson.json.gateway.PresenceUpdate;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.discordjson.json.gateway.UserUpdate;
import discord4j.discordjson.json.gateway.VoiceStateUpdateDispatch;
import discord4j.discordjson.possible.Possible;
import discord4j.store.api.service.StoreService;
import discord4j.store.api.util.LongLongTuple2;
import discord4j.store.api.util.LongObjTuple2;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class LegacyStoreLayout
implements StoreLayout,
DataAccessor,
GatewayDataUpdater {
    private static final Logger log = Loggers.getLogger(LegacyStoreLayout.class);
    private final StateHolder stateHolder;

    private LegacyStoreLayout(StoreService storeService) {
        this.stateHolder = new StateHolder(storeService);
    }

    public static LegacyStoreLayout of(StoreService storeService) {
        return new LegacyStoreLayout(storeService);
    }

    @Override
    public DataAccessor getDataAccessor() {
        return this;
    }

    @Override
    public GatewayDataUpdater getGatewayDataUpdater() {
        return this;
    }

    @Override
    public Mono<Long> countChannels() {
        return this.stateHolder.getChannelStore().count();
    }

    @Override
    public Mono<Long> countChannelsInGuild(long guildId) {
        return this.getChannelsInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countStickers() {
        return this.stateHolder.getGuildStickerStore().count();
    }

    @Override
    public Mono<Long> countStickersInGuild(long guildId) {
        return this.getStickersInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countEmojis() {
        return this.stateHolder.getGuildEmojiStore().count();
    }

    @Override
    public Mono<Long> countEmojisInGuild(long guildId) {
        return this.getEmojisInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countGuilds() {
        return this.stateHolder.getGuildStore().count();
    }

    @Override
    public Mono<Long> countMembers() {
        return this.stateHolder.getMemberStore().count();
    }

    @Override
    public Mono<Long> countMembersInGuild(long guildId) {
        return this.getMembersInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countExactMembersInGuild(long guildId) {
        return this.countMembersInGuild(guildId);
    }

    @Override
    public Mono<Long> countMessages() {
        return this.stateHolder.getMessageStore().count();
    }

    @Override
    public Mono<Long> countMessagesInChannel(long channelId) {
        return this.getMessagesInChannel(channelId).count();
    }

    @Override
    public Mono<Long> countPresences() {
        return this.stateHolder.getPresenceStore().count();
    }

    @Override
    public Mono<Long> countPresencesInGuild(long guildId) {
        return this.getPresencesInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countRoles() {
        return this.stateHolder.getRoleStore().count();
    }

    @Override
    public Mono<Long> countRolesInGuild(long guildId) {
        return this.getRolesInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countUsers() {
        return this.stateHolder.getUserStore().count();
    }

    @Override
    public Mono<Long> countVoiceStates() {
        return this.stateHolder.getVoiceStateStore().count();
    }

    @Override
    public Mono<Long> countVoiceStatesInGuild(long guildId) {
        return this.getVoiceStatesInGuild(guildId).count();
    }

    @Override
    public Mono<Long> countVoiceStatesInChannel(long guildId, long channelId) {
        return this.getVoiceStatesInChannel(guildId, channelId).count();
    }

    @Override
    public Flux<ChannelData> getChannels() {
        return this.stateHolder.getChannelStore().values();
    }

    @Override
    public Flux<ChannelData> getChannelsInGuild(long guildId) {
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> Flux.fromStream(guild.channels().stream().map(Snowflake::asLong))).flatMap(id -> this.stateHolder.getChannelStore().find(id));
    }

    @Override
    public Mono<ChannelData> getChannelById(long channelId) {
        return this.stateHolder.getChannelStore().find(channelId);
    }

    @Override
    public Flux<StickerData> getStickers() {
        return this.stateHolder.getGuildStickerStore().values();
    }

    @Override
    public Flux<StickerData> getStickersInGuild(long guildId) {
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> Flux.fromStream(guild.stickers().toOptional().orElse(Collections.emptyList()).stream().map(Snowflake::asLong))).flatMap(id -> this.stateHolder.getGuildStickerStore().find(id));
    }

    @Override
    public Mono<StickerData> getStickerById(long guildId, long stickerId) {
        return this.stateHolder.getGuildStickerStore().find(stickerId);
    }

    @Override
    public Flux<EmojiData> getEmojis() {
        return this.stateHolder.getGuildEmojiStore().values();
    }

    @Override
    public Flux<EmojiData> getEmojisInGuild(long guildId) {
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> Flux.fromStream(guild.emojis().stream().map(Snowflake::asLong))).flatMap(id -> this.stateHolder.getGuildEmojiStore().find(id));
    }

    @Override
    public Mono<EmojiData> getEmojiById(long guildId, long emojiId) {
        return this.stateHolder.getGuildEmojiStore().find(emojiId);
    }

    @Override
    public Flux<GuildData> getGuilds() {
        return this.stateHolder.getGuildStore().values();
    }

    @Override
    public Mono<GuildData> getGuildById(long guildId) {
        return this.stateHolder.getGuildStore().find(guildId);
    }

    @Override
    public Flux<GuildScheduledEventData> getScheduledEventsInGuild(long guildId) {
        return this.stateHolder.getGuildEventsStore().findInRange((Comparable)LongLongTuple2.of((long)guildId, (long)0L), (Comparable)LongLongTuple2.of((long)guildId, (long)Long.MAX_VALUE));
    }

    @Override
    public Mono<GuildScheduledEventData> getScheduledEventById(long guildId, long eventId) {
        return this.stateHolder.getGuildEventsStore().find((Comparable)LongLongTuple2.of((long)guildId, (long)eventId));
    }

    @Override
    public Flux<Id> getScheduledEventUsersInEvent(long guildId, long eventId) {
        return this.stateHolder.getGuildEventsUsersStore().find((Comparable)LongLongTuple2.of((long)guildId, (long)eventId)).flatMapIterable(list -> list).map(value -> Id.of((long)((Long)value)));
    }

    @Override
    public Flux<MemberData> getMembers() {
        return this.stateHolder.getMemberStore().values();
    }

    @Override
    public Flux<MemberData> getMembersInGuild(long guildId) {
        return this.stateHolder.getMemberStore().findInRange((Comparable)LongLongTuple2.of((long)guildId, (long)0L), (Comparable)LongLongTuple2.of((long)guildId, (long)Long.MAX_VALUE));
    }

    @Override
    public Flux<MemberData> getExactMembersInGuild(long guildId) {
        return this.stateHolder.getMemberStore().findInRange((Comparable)LongLongTuple2.of((long)guildId, (long)0L), (Comparable)LongLongTuple2.of((long)guildId, (long)Long.MAX_VALUE));
    }

    @Override
    public Mono<MemberData> getMemberById(long guildId, long userId) {
        return this.stateHolder.getMemberStore().find((Comparable)LongLongTuple2.of((long)guildId, (long)userId));
    }

    @Override
    public Flux<MessageData> getMessages() {
        return this.stateHolder.getMessageStore().values();
    }

    @Override
    public Flux<MessageData> getMessagesInChannel(long channelId) {
        return this.stateHolder.getMessageStore().values().filter(data -> Snowflake.asLong(data.channelId()) == channelId);
    }

    @Override
    public Mono<MessageData> getMessageById(long channelId, long messageId) {
        return this.stateHolder.getMessageStore().find(messageId);
    }

    @Override
    public Flux<PresenceData> getPresences() {
        return this.stateHolder.getPresenceStore().values();
    }

    @Override
    public Flux<PresenceData> getPresencesInGuild(long guildId) {
        return this.stateHolder.getPresenceStore().findInRange((Comparable)LongLongTuple2.of((long)guildId, (long)0L), (Comparable)LongLongTuple2.of((long)guildId, (long)Long.MAX_VALUE));
    }

    @Override
    public Mono<PresenceData> getPresenceById(long guildId, long userId) {
        return this.stateHolder.getPresenceStore().find((Comparable)LongLongTuple2.of((long)guildId, (long)userId));
    }

    @Override
    public Flux<RoleData> getRoles() {
        return this.stateHolder.getRoleStore().values();
    }

    @Override
    public Flux<RoleData> getRolesInGuild(long guildId) {
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> Flux.fromStream(guild.roles().stream().map(Snowflake::asLong))).flatMap(id -> this.stateHolder.getRoleStore().find(id));
    }

    @Override
    public Mono<RoleData> getRoleById(long guildId, long roleId) {
        return this.stateHolder.getRoleStore().find(roleId);
    }

    @Override
    public Flux<UserData> getUsers() {
        return this.stateHolder.getUserStore().values();
    }

    @Override
    public Mono<UserData> getUserById(long userId) {
        return this.stateHolder.getUserStore().find(userId);
    }

    @Override
    public Flux<VoiceStateData> getVoiceStates() {
        return this.stateHolder.getVoiceStateStore().values();
    }

    @Override
    public Flux<VoiceStateData> getVoiceStatesInChannel(long guildId, long channelId) {
        return this.stateHolder.getVoiceStateStore().findInRange((Comparable)LongLongTuple2.of((long)guildId, (long)0L), (Comparable)LongLongTuple2.of((long)guildId, (long)Long.MAX_VALUE)).filter(data -> data.channelId().filter(id -> Snowflake.asLong(id) == channelId).isPresent());
    }

    @Override
    public Flux<VoiceStateData> getVoiceStatesInGuild(long guildId) {
        return this.stateHolder.getVoiceStateStore().findInRange((Comparable)LongLongTuple2.of((long)guildId, (long)0L), (Comparable)LongLongTuple2.of((long)guildId, (long)Long.MAX_VALUE));
    }

    @Override
    public Mono<VoiceStateData> getVoiceStateById(long guildId, long userId) {
        return this.stateHolder.getVoiceStateStore().find((Comparable)LongLongTuple2.of((long)guildId, (long)userId));
    }

    @Override
    public Mono<Void> onChannelCreate(int shardIndex, ChannelCreate dispatch) {
        Type type = Type.of(dispatch.channel().type());
        switch (type) {
            case GUILD_TEXT: 
            case GUILD_VOICE: 
            case GUILD_CATEGORY: 
            case GUILD_NEWS: 
            case GUILD_STORE: 
            case GUILD_STAGE_VOICE: {
                return this.saveChannel(dispatch);
            }
            case DM: 
            case GROUP_DM: {
                return Mono.empty();
            }
        }
        throw new IllegalArgumentException("Unhandled channel type " + dispatch.channel().type());
    }

    private Mono<Void> saveChannel(ChannelCreate dispatch) {
        ChannelData channel = dispatch.channel();
        Mono addChannelToGuild = this.stateHolder.getGuildStore().find(Snowflake.asLong((Id)channel.guildId().get())).map(guildData -> GuildData.builder().from(guildData).channels(ListUtil.add(guildData.channels(), channel.id())).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Long.valueOf(Snowflake.asLong(guild.id())), guild));
        Mono saveChannel = this.stateHolder.getChannelStore().save(Long.valueOf(Snowflake.asLong(channel.id())), (Object)channel);
        return addChannelToGuild.then(saveChannel);
    }

    @Override
    public Mono<ChannelData> onChannelDelete(int shardIndex, ChannelDelete dispatch) {
        Type type = Type.of(dispatch.channel().type());
        switch (type) {
            case GUILD_TEXT: 
            case GUILD_VOICE: 
            case GUILD_CATEGORY: 
            case GUILD_NEWS: 
            case GUILD_STORE: 
            case GUILD_STAGE_VOICE: {
                return this.deleteChannel(dispatch);
            }
            case DM: 
            case GROUP_DM: {
                return Mono.empty();
            }
        }
        throw new IllegalArgumentException("Unhandled channel type " + dispatch.channel().type());
    }

    private Mono<ChannelData> deleteChannel(ChannelDelete dispatch) {
        ChannelData channel = dispatch.channel();
        Mono removeChannelFromGuild = this.stateHolder.getGuildStore().find(Snowflake.asLong((Id)channel.guildId().get())).map(guildData -> GuildData.builder().from(guildData).channels(ListUtil.remove(guildData.channels(), ch -> channel.id().equals(ch))).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Long.valueOf(Snowflake.asLong(guild.id())), guild));
        Mono deleteChannel = this.stateHolder.getChannelStore().delete(Snowflake.asLong(channel.id()));
        return removeChannelFromGuild.then(deleteChannel).thenReturn((Object)channel);
    }

    @Override
    public Mono<ChannelData> onChannelUpdate(int shardIndex, ChannelUpdate dispatch) {
        Type type = Type.of(dispatch.channel().type());
        switch (type) {
            case GUILD_TEXT: 
            case GUILD_VOICE: 
            case GUILD_CATEGORY: 
            case GUILD_NEWS: 
            case GUILD_STORE: 
            case GUILD_STAGE_VOICE: {
                return this.updateChannel(dispatch);
            }
            case DM: 
            case GROUP_DM: {
                return Mono.empty();
            }
        }
        throw new IllegalArgumentException("Unhandled channel type " + dispatch.channel().type());
    }

    private Mono<ChannelData> updateChannel(ChannelUpdate dispatch) {
        ChannelData channel = dispatch.channel();
        Mono saveNew = this.stateHolder.getChannelStore().save(Long.valueOf(Snowflake.asLong(channel.id())), (Object)channel);
        return this.stateHolder.getChannelStore().find(Snowflake.asLong(channel.id())).flatMap(arg_0 -> ((Mono)saveNew).thenReturn(arg_0)).switchIfEmpty(saveNew.then(Mono.empty()));
    }

    @Override
    public Mono<Void> onGuildCreate(int shardIndex, GuildCreate dispatch) {
        ImmutableGuildData guild;
        GuildCreateData createData;
        if (dispatch.guild().large()) {
            createData = GuildCreateData.builder().from(dispatch.guild()).members(Collections.emptyList()).build();
            guild = GuildData.builder().from((GuildCreateFields)createData).roles(createData.roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(createData.emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).channels(createData.channels().stream().map(ChannelData::id).collect(Collectors.toList())).build();
        } else {
            createData = dispatch.guild();
            guild = GuildData.builder().from((GuildCreateFields)createData).roles(createData.roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(createData.emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).members(createData.members().stream().map(data -> data.user().id()).distinct().collect(Collectors.toList())).channels(createData.channels().stream().map(ChannelData::id).collect(Collectors.toList())).build();
        }
        long guildId = Snowflake.asLong(guild.id());
        Mono saveGuild = this.stateHolder.getGuildStore().save(Long.valueOf(guildId), (Object)guild).doOnSubscribe(s -> log.trace("GuildCreate doOnSubscribe {}", new Object[]{guildId})).doFinally(s -> log.trace("GuildCreate doFinally {}: {}", new Object[]{guildId, s}));
        Mono saveChannels = this.stateHolder.getChannelStore().save((Publisher)Flux.fromIterable((Iterable)createData.channels()).map(arg_0 -> LegacyStoreLayout.lambda$onGuildCreate$21((GuildData)guild, arg_0)));
        Mono saveRoles = this.stateHolder.getRoleStore().save((Publisher)Flux.fromIterable((Iterable)createData.roles()).map(role -> Tuples.of((Object)Snowflake.asLong(role.id()), (Object)role)));
        Mono saveEmojis = this.stateHolder.getGuildEmojiStore().save((Publisher)Flux.fromIterable((Iterable)createData.emojis()).map(emoji -> Tuples.of((Object)Snowflake.asLong((Id)emoji.id().orElseThrow(NoSuchElementException::new)), (Object)emoji)));
        Mono saveMembers = this.stateHolder.getMemberStore().save((Publisher)Flux.fromIterable((Iterable)createData.members()).map(member -> Tuples.of((Object)LongLongTuple2.of((long)guildId, (long)Snowflake.asLong(member.user().id())), (Object)member)));
        Mono saveUsers = this.stateHolder.getUserStore().save((Publisher)Flux.fromIterable((Iterable)createData.members()).map(MemberData::user).map(user -> Tuples.of((Object)Snowflake.asLong(user.id()), (Object)user)));
        Mono saveVoiceStates = this.stateHolder.getVoiceStateStore().save((Publisher)Flux.fromIterable((Iterable)createData.voiceStates()).map(arg_0 -> LegacyStoreLayout.lambda$onGuildCreate$26(guildId, (GuildData)guild, arg_0)));
        Mono savePresences = this.stateHolder.getPresenceStore().save((Publisher)Flux.fromIterable((Iterable)createData.presences()).map(presence -> Tuples.of((Object)LongLongTuple2.of((long)guildId, (long)Snowflake.asLong(presence.user().id())), (Object)presence)));
        Mono saveOfflinePresences = Flux.fromIterable((Iterable)createData.members()).filterWhen(member -> this.stateHolder.getPresenceStore().find((Comparable)LongLongTuple2.of((long)guildId, (long)Snowflake.asLong(member.user().id()))).hasElement().map(id -> id == false)).flatMap(member -> this.stateHolder.getPresenceStore().save((Comparable)LongLongTuple2.of((long)guildId, (long)Snowflake.asLong(member.user().id())), (Object)this.createPresence((MemberData)member))).then();
        return saveGuild.and((Publisher)saveChannels).and((Publisher)saveRoles).and((Publisher)saveEmojis).and((Publisher)saveMembers).and((Publisher)saveUsers).and((Publisher)saveVoiceStates).and((Publisher)savePresences).and((Publisher)saveOfflinePresences);
    }

    private PresenceData createPresence(MemberData member) {
        return PresenceData.builder().user((PartialUserData)PartialUserData.builder().id(member.user().id()).globalName(Possible.of((Object)member.user().globalName())).username(member.user().username()).discriminator(member.user().discriminator()).avatar(Possible.of((Object)member.user().avatar())).bot(member.user().bot()).system(member.user().system()).mfaEnabled(member.user().mfaEnabled()).locale(member.user().locale()).verified(member.user().verified()).email(member.user().email().isAbsent() ? Possible.absent() : ((Optional)member.user().email().get()).map(Possible::of).orElse(Possible.absent())).flags(member.user().flags()).premiumType(member.user().premiumType()).build()).status("offline").clientStatus((ClientStatusData)ClientStatusData.builder().desktop(Possible.absent()).mobile(Possible.absent()).web(Possible.absent()).build()).build();
    }

    @Override
    public Mono<GuildData> onGuildDelete(int shardIndex, GuildDelete dispatch) {
        long guildId = Snowflake.asLong(dispatch.guild().id());
        Mono deleteGuild = this.stateHolder.getGuildStore().delete(guildId);
        return this.stateHolder.getGuildStore().find(guildId).flatMap(guild -> {
            Flux channels = Flux.fromIterable((Iterable)guild.channels()).map(Snowflake::asLong);
            Flux roles = Flux.fromIterable((Iterable)guild.roles()).map(Snowflake::asLong);
            Flux emojis = Flux.fromIterable((Iterable)guild.emojis()).map(Snowflake::asLong);
            Mono deleteChannels = this.stateHolder.getChannelStore().delete((Publisher)channels);
            Mono deleteRoles = this.stateHolder.getRoleStore().delete((Publisher)roles);
            Mono deleteEmojis = this.stateHolder.getGuildEmojiStore().delete((Publisher)emojis);
            Mono deleteMembers = this.stateHolder.getMemberStore().deleteInRange((Comparable)LongLongTuple2.of((long)guildId, (long)0L), (Comparable)LongLongTuple2.of((long)guildId, (long)-1L));
            Mono deleteVoiceStates = this.stateHolder.getVoiceStateStore().deleteInRange((Comparable)LongLongTuple2.of((long)guildId, (long)0L), (Comparable)LongLongTuple2.of((long)guildId, (long)-1L));
            Mono deletePresences = this.stateHolder.getPresenceStore().deleteInRange((Comparable)LongLongTuple2.of((long)guildId, (long)0L), (Comparable)LongLongTuple2.of((long)guildId, (long)-1L));
            return deleteChannels.and((Publisher)deleteRoles).and((Publisher)deleteEmojis).and((Publisher)deleteMembers).and((Publisher)deleteVoiceStates).and((Publisher)deletePresences).thenReturn(guild);
        }).flatMap(arg_0 -> ((Mono)deleteGuild).thenReturn(arg_0));
    }

    @Override
    public Mono<Set<StickerData>> onGuildStickersUpdate(int shardIndex, GuildStickersUpdate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        Mono updateGuildBean = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from(guild).emojis(dispatch.stickers().stream().map(PartialStickerData::id).collect(Collectors.toList())).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Long.valueOf(guildId), guild)).doOnSubscribe(s -> log.trace("GuildStickersUpdate doOnSubscribe {}", new Object[]{guildId})).doFinally(s -> log.trace("GuildStickersUpdate doFinally {}: {}", new Object[]{guildId, s}));
        Mono saveStickers = this.stateHolder.getGuildStickerStore().saveWithLong((Publisher)Flux.fromIterable((Iterable)dispatch.stickers()).map(sticker -> LongObjTuple2.of((long)Snowflake.asLong(sticker.id()), (Object)sticker)));
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> updateGuildBean.and((Publisher)saveStickers).thenMany((Publisher)Flux.fromIterable((Iterable)guild.stickers().toOptional().orElse(Collections.emptyList())).map(Snowflake::asLong).flatMap(id -> this.stateHolder.getGuildStickerStore().find(id)))).collect(Collectors.toSet());
    }

    @Override
    public Mono<Set<EmojiData>> onGuildEmojisUpdate(int shardIndex, GuildEmojisUpdate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        Mono updateGuildBean = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from(guild).emojis(dispatch.emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Long.valueOf(guildId), guild)).doOnSubscribe(s -> log.trace("GuildEmojisUpdate doOnSubscribe {}", new Object[]{guildId})).doFinally(s -> log.trace("GuildEmojisUpdate doFinally {}: {}", new Object[]{guildId, s}));
        Mono saveEmojis = this.stateHolder.getGuildEmojiStore().saveWithLong((Publisher)Flux.fromIterable((Iterable)dispatch.emojis()).map(emoji -> LongObjTuple2.of((long)emoji.id().map(Snowflake::asLong).orElseThrow(NoSuchElementException::new), (Object)emoji)));
        return this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> updateGuildBean.and((Publisher)saveEmojis).thenMany((Publisher)Flux.fromIterable((Iterable)guild.emojis()).map(Snowflake::asLong).flatMap(id -> this.stateHolder.getGuildEmojiStore().find(id)))).collect(Collectors.toSet());
    }

    @Override
    public Mono<Void> onGuildMemberAdd(int shardIndex, GuildMemberAdd dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        MemberData member = dispatch.member();
        UserData user = member.user();
        long userId = Snowflake.asLong(user.id());
        Mono addMemberId = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from(guild).members(ListUtil.add(guild.members(), member.user().id())).memberCount(guild.memberCount() + 1).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Long.valueOf(guildId), guild)).doOnSubscribe(s -> log.trace("GuildMemberAdd doOnSubscribe {}", new Object[]{guildId})).doFinally(s -> log.trace("GuildMemberAdd doFinally {}: {}", new Object[]{guildId, s}));
        Mono saveMember = this.stateHolder.getMemberStore().save((Comparable)LongLongTuple2.of((long)guildId, (long)userId), (Object)member);
        Mono saveUser = this.stateHolder.getUserStore().save(Long.valueOf(userId), (Object)user);
        return addMemberId.and((Publisher)saveMember).and((Publisher)saveUser);
    }

    @Override
    public Mono<MemberData> onGuildMemberRemove(int shardIndex, GuildMemberRemove dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        UserData userData = dispatch.user();
        long userId = Snowflake.asLong(userData.id());
        Mono removeMemberId = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from(guild).members(ListUtil.remove(guild.members(), member -> member.equals((Object)userData.id()))).memberCount(guild.memberCount() - 1).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Long.valueOf(guildId), guild)).doOnSubscribe(s -> log.trace("GuildMemberRemove doOnSubscribe {}", new Object[]{guildId})).doFinally(s -> log.trace("GuildMemberRemove doFinally {}: {}", new Object[]{guildId, s}));
        Mono member = this.stateHolder.getMemberStore().find((Comparable)LongLongTuple2.of((long)guildId, (long)userId));
        Mono deleteMember = this.stateHolder.getMemberStore().delete((Comparable)LongLongTuple2.of((long)guildId, (long)userId));
        Mono deletePresence = this.stateHolder.getPresenceStore().delete((Comparable)LongLongTuple2.of((long)guildId, (long)userId));
        Mono deleteOrphanUser = this.stateHolder.getMemberStore().keys().filter(key -> key.getT1() != guildId && key.getT2() == userId).hasElements().flatMap(hasMutualServers -> Mono.just((Object)userId).filter(__ -> hasMutualServers == false).flatMap(arg_0 -> this.stateHolder.getUserStore().delete(arg_0)));
        return member.flatMap(value -> Mono.when((Publisher[])new Publisher[]{removeMemberId, deleteMember, deletePresence, deleteOrphanUser}).thenReturn(value));
    }

    @Override
    public Mono<Void> onGuildMembersChunk(int shardIndex, GuildMembersChunk dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        List members = dispatch.members();
        Flux memberPairs = Flux.fromIterable((Iterable)members).map(data -> Tuples.of((Object)LongLongTuple2.of((long)guildId, (long)Snowflake.asLong(data.user().id())), (Object)data));
        Flux userPairs = Flux.fromIterable((Iterable)members).map(data -> Tuples.of((Object)Snowflake.asLong(data.user().id()), (Object)data.user()));
        Mono addMemberIds = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from(guild).members(ListUtil.addAllDistinct(guild.members(), members.stream().map(data -> data.user().id()).collect(Collectors.toList()))).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Long.valueOf(guildId), guild)).doOnSubscribe(s -> log.trace("GuildMembersChunk doOnSubscribe {}", new Object[]{guildId})).doFinally(s -> log.trace("GuildMembersChunk doFinally {}: {}", new Object[]{guildId, s}));
        Mono saveMembers = this.stateHolder.getMemberStore().save((Publisher)memberPairs);
        Mono saveUsers = this.stateHolder.getUserStore().save((Publisher)userPairs);
        Mono saveOfflinePresences = Flux.fromIterable((Iterable)members).filterWhen(member -> this.stateHolder.getPresenceStore().find((Comparable)LongLongTuple2.of((long)guildId, (long)Snowflake.asLong(member.user().id()))).hasElement().map(identity -> identity == false)).flatMap(member -> this.stateHolder.getPresenceStore().save((Comparable)LongLongTuple2.of((long)guildId, (long)Snowflake.asLong(member.user().id())), (Object)this.createPresence((MemberData)member))).then();
        return addMemberIds.and((Publisher)saveMembers).and((Publisher)saveUsers).and((Publisher)saveOfflinePresences);
    }

    @Override
    public Mono<MemberData> onGuildMemberUpdate(int shardIndex, GuildMemberUpdate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        long memberId = Snowflake.asLong(dispatch.user().id());
        LongLongTuple2 key = LongLongTuple2.of((long)guildId, (long)memberId);
        return this.stateHolder.getMemberStore().find((Comparable)key).flatMap(oldMember -> {
            ImmutableMemberData newMember = MemberData.builder().from(oldMember).roles(dispatch.roles().stream().map(Id::of).collect(Collectors.toList())).user(dispatch.user()).nick(dispatch.nick()).joinedAt(dispatch.joinedAt()).premiumSince(dispatch.premiumSince()).pending(dispatch.pending()).build();
            return this.stateHolder.getMemberStore().save((Comparable)key, (Object)newMember).thenReturn(oldMember);
        });
    }

    @Override
    public Mono<Void> onGuildRoleCreate(int shardIndex, GuildRoleCreate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        RoleData role = dispatch.role();
        Mono addRoleId = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from(guild).addRole(role.id()).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Long.valueOf(guildId), guild)).doOnSubscribe(s -> log.trace("GuildRoleCreate doOnSubscribe {}", new Object[]{guildId})).doFinally(s -> log.trace("GuildRoleCreate doFinally {}: {}", new Object[]{guildId, s}));
        Mono saveRole = this.stateHolder.getRoleStore().save(Long.valueOf(Snowflake.asLong(role.id())), (Object)role);
        return addRoleId.and((Publisher)saveRole);
    }

    @Override
    public Mono<RoleData> onGuildRoleDelete(int shardIndex, GuildRoleDelete dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        long roleId = Snowflake.asLong(dispatch.roleId());
        Mono removeRoleId = this.stateHolder.getGuildStore().find(guildId).map(guild -> GuildData.builder().from(guild).roles(ListUtil.remove(guild.roles(), role -> role.equals((Object)dispatch.roleId()))).build()).flatMap(guild -> this.stateHolder.getGuildStore().save(Long.valueOf(guildId), guild)).doOnSubscribe(s -> log.trace("GuildRoleDelete doOnSubscribe {}", new Object[]{guildId})).doFinally(s -> log.trace("GuildRoleDelete doFinally {}: {}", new Object[]{guildId, s}));
        Mono deleteRole = this.stateHolder.getRoleStore().delete(roleId);
        Mono removeRoleFromMembers = this.stateHolder.getGuildStore().find(guildId).flatMapMany(guild -> Flux.fromIterable((Iterable)guild.members()).map(Snowflake::asLong)).flatMap(memberId -> this.stateHolder.getMemberStore().find((Comparable)LongLongTuple2.of((long)guildId, (long)memberId))).filter(member -> member.roles().contains(dispatch.roleId())).map(member -> MemberData.builder().from(member).roles(ListUtil.remove(member.roles(), role -> role.equals((Object)dispatch.roleId()))).build()).flatMap(member -> this.stateHolder.getMemberStore().save((Comparable)LongLongTuple2.of((long)guildId, (long)Snowflake.asLong(member.user().id())), member)).then();
        return this.stateHolder.getRoleStore().find(roleId).flatMap(arg_0 -> ((Mono)removeRoleId).thenReturn(arg_0)).flatMap(arg_0 -> ((Mono)deleteRole).thenReturn(arg_0)).flatMap(arg_0 -> ((Mono)removeRoleFromMembers).thenReturn(arg_0));
    }

    @Override
    public Mono<RoleData> onGuildRoleUpdate(int shardIndex, GuildRoleUpdate dispatch) {
        RoleData role = dispatch.role();
        long roleId = Snowflake.asLong(role.id());
        Mono saveNew = this.stateHolder.getRoleStore().save(Long.valueOf(roleId), (Object)role);
        return this.stateHolder.getRoleStore().find(roleId).flatMap(arg_0 -> ((Mono)saveNew).thenReturn(arg_0)).switchIfEmpty(saveNew.then(Mono.empty()));
    }

    @Override
    public Mono<Void> onGuildScheduledEventCreate(int shardIndex, GuildScheduledEventCreate dispatch) {
        LongLongTuple2 key = LongLongTuple2.of((long)dispatch.scheduledEvent().guildId().asLong(), (long)dispatch.scheduledEvent().id().asLong());
        return this.stateHolder.getGuildEventsStore().save((Comparable)key, (Object)dispatch.scheduledEvent());
    }

    @Override
    public Mono<GuildScheduledEventData> onGuildScheduledEventUpdate(int shardIndex, GuildScheduledEventUpdate dispatch) {
        LongLongTuple2 key = LongLongTuple2.of((long)dispatch.scheduledEvent().guildId().asLong(), (long)dispatch.scheduledEvent().id().asLong());
        Mono saveNew = this.stateHolder.getGuildEventsStore().save((Comparable)key, (Object)dispatch.scheduledEvent());
        return this.stateHolder.getGuildEventsStore().find((Comparable)key).flatMap(arg_0 -> ((Mono)saveNew).thenReturn(arg_0)).switchIfEmpty(saveNew.then(Mono.empty()));
    }

    @Override
    public Mono<GuildScheduledEventData> onGuildScheduledEventDelete(int shardIndex, GuildScheduledEventDelete dispatch) {
        LongLongTuple2 key = LongLongTuple2.of((long)dispatch.scheduledEvent().guildId().asLong(), (long)dispatch.scheduledEvent().id().asLong());
        Mono deletion = this.stateHolder.getGuildEventsStore().delete((Comparable)key);
        return this.stateHolder.getGuildEventsStore().find((Comparable)key).flatMap(arg_0 -> ((Mono)deletion).thenReturn(arg_0)).switchIfEmpty(deletion.then(Mono.empty()));
    }

    @Override
    public Mono<Void> onGuildScheduledEventUserAdd(int shardIndex, GuildScheduledEventUserAdd dispatch) {
        LongLongTuple2 key = LongLongTuple2.of((long)dispatch.guildId().asLong(), (long)dispatch.scheduledEventId().asLong());
        return this.stateHolder.getGuildEventsUsersStore().find((Comparable)key).defaultIfEmpty(new HashSet()).map(set -> {
            set.add(dispatch.userId().asLong());
            return set;
        }).flatMap(set -> this.stateHolder.getGuildEventsUsersStore().save((Comparable)key, set));
    }

    @Override
    public Mono<Void> onGuildScheduledEventUserRemove(int shardIndex, GuildScheduledEventUserRemove dispatch) {
        LongLongTuple2 key = LongLongTuple2.of((long)dispatch.guildId().asLong(), (long)dispatch.scheduledEventId().asLong());
        return this.stateHolder.getGuildEventsUsersStore().find((Comparable)key).defaultIfEmpty(new HashSet()).map(set -> {
            set.remove(dispatch.userId().asLong());
            return set;
        }).flatMap(set -> this.stateHolder.getGuildEventsUsersStore().save((Comparable)key, set));
    }

    @Override
    public Mono<GuildData> onGuildUpdate(int shardIndex, GuildUpdate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guild().id());
        return this.stateHolder.getGuildStore().find(guildId).flatMap(oldGuildData -> {
            ImmutableGuildData newGuildData = GuildData.builder().from(oldGuildData).from((GuildUpdateFields)dispatch.guild()).roles(dispatch.guild().roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(dispatch.guild().emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).build();
            return this.stateHolder.getGuildStore().save(Long.valueOf(guildId), (Object)newGuildData).doOnSubscribe(s -> log.trace("GuildUpdate doOnSubscribe {}", new Object[]{guildId})).doFinally(s -> log.trace("GuildUpdate doFinally {}: {}", new Object[]{guildId, s})).thenReturn(oldGuildData);
        });
    }

    @Override
    public Mono<Void> onShardInvalidation(int shardIndex, InvalidationCause cause) {
        return Mono.empty();
    }

    @Override
    public Mono<Void> onMessageCreate(int shardIndex, MessageCreate dispatch) {
        MessageData message = dispatch.message();
        long messageId = Snowflake.asLong(message.id());
        long channelId = Snowflake.asLong(message.channelId());
        Mono saveMessage = this.stateHolder.getMessageStore().save(Long.valueOf(messageId), (Object)message);
        Mono editLastMessageId = this.stateHolder.getChannelStore().find(channelId).map(channel -> ChannelData.builder().from(channel).lastMessageId(message.id()).build()).flatMap(channelBean -> this.stateHolder.getChannelStore().save(Long.valueOf(channelId), channelBean));
        return saveMessage.and((Publisher)editLastMessageId);
    }

    @Override
    public Mono<MessageData> onMessageDelete(int shardIndex, MessageDelete dispatch) {
        long messageId = Snowflake.asLong(dispatch.id());
        Mono deleteMessage = this.stateHolder.getMessageStore().delete(messageId);
        return this.stateHolder.getMessageStore().find(messageId).flatMap(arg_0 -> ((Mono)deleteMessage).thenReturn(arg_0));
    }

    @Override
    public Mono<Set<MessageData>> onMessageDeleteBulk(int shardIndex, MessageDeleteBulk dispatch) {
        List messageIds = dispatch.ids().stream().map(Snowflake::asLong).collect(Collectors.toList());
        Mono deleteMessages = this.stateHolder.getMessageStore().delete((Publisher)Flux.fromIterable(messageIds));
        return Flux.fromIterable(messageIds).flatMap(arg_0 -> this.stateHolder.getMessageStore().find(arg_0)).flatMap(arg_0 -> ((Mono)deleteMessages).thenReturn(arg_0)).collect(Collectors.toSet());
    }

    @Override
    public Mono<Void> onMessageReactionAdd(int shardIndex, MessageReactionAdd dispatch) {
        long selfId = 0L;
        long userId = Snowflake.asLong(dispatch.userId());
        long messageId = Snowflake.asLong(dispatch.messageId());
        return this.stateHolder.getMessageStore().find(messageId).map(oldMessage -> {
            boolean me = Objects.equals(userId, selfId);
            ImmutableMessageData.Builder newMessageBuilder = MessageData.builder().from(oldMessage);
            if (oldMessage.reactions().isAbsent()) {
                newMessageBuilder.addReaction((ReactionData)ReactionData.builder().count(1).me(me).emoji(dispatch.emoji()).build());
            } else {
                List reactions = (List)oldMessage.reactions().get();
                int i = this.indexOfReactionByEmojiData(reactions, dispatch.emoji());
                if (i < reactions.size()) {
                    ReactionData oldExisting = (ReactionData)reactions.get(i);
                    ImmutableReactionData newExisting = ReactionData.builder().from(oldExisting).me(oldExisting.me() || me).count(oldExisting.count() + 1).build();
                    newMessageBuilder.reactions(ListUtil.replace(reactions, oldExisting, newExisting));
                } else {
                    ImmutableReactionData reaction = ReactionData.builder().emoji(dispatch.emoji()).me(me).count(1).build();
                    newMessageBuilder.reactions(ListUtil.add(reactions, reaction));
                }
            }
            return newMessageBuilder.build();
        }).flatMap(message -> this.stateHolder.getMessageStore().save(Long.valueOf(messageId), message));
    }

    @Override
    public Mono<Void> onMessageReactionRemove(int shardIndex, MessageReactionRemove dispatch) {
        long selfId = 0L;
        long userId = Snowflake.asLong(dispatch.userId());
        long messageId = Snowflake.asLong(dispatch.messageId());
        return this.stateHolder.getMessageStore().find(messageId).filter(message -> !message.reactions().isAbsent()).map(oldMessage -> {
            boolean me = Objects.equals(userId, selfId);
            ImmutableMessageData.Builder newMessageBuilder = MessageData.builder().from(oldMessage);
            List reactions = (List)oldMessage.reactions().get();
            int i = this.indexOfReactionByEmojiData(reactions, dispatch.emoji());
            if (i < reactions.size()) {
                ReactionData existing = (ReactionData)reactions.get(i);
                if (existing.count() - 1 == 0) {
                    newMessageBuilder.reactions(ListUtil.remove(reactions, reaction -> reaction.equals(existing)));
                } else {
                    ImmutableReactionData newExisting = ReactionData.builder().from(existing).count(existing.count() - 1).me(!me && existing.me()).build();
                    newMessageBuilder.reactions(ListUtil.replace(reactions, existing, newExisting));
                }
            }
            return newMessageBuilder.build();
        }).flatMap(message -> this.stateHolder.getMessageStore().save(Long.valueOf(messageId), message));
    }

    @Override
    public Mono<Void> onMessageReactionRemoveAll(int shardIndex, MessageReactionRemoveAll dispatch) {
        long messageId = Snowflake.asLong(dispatch.messageId());
        return this.stateHolder.getMessageStore().find(messageId).map(message -> MessageData.builder().from(message).reactions(Possible.absent()).build()).flatMap(message -> this.stateHolder.getMessageStore().save(Long.valueOf(messageId), message));
    }

    @Override
    public Mono<Void> onMessageReactionRemoveEmoji(int shardIndex, MessageReactionRemoveEmoji dispatch) {
        long messageId = Snowflake.asLong(dispatch.messageId());
        return this.stateHolder.getMessageStore().find(messageId).filter(message -> !message.reactions().isAbsent()).map(oldMessage -> {
            ImmutableMessageData.Builder newMessageBuilder = MessageData.builder().from(oldMessage);
            List reactions = (List)oldMessage.reactions().get();
            int i = this.indexOfReactionByEmojiData(reactions, dispatch.emoji());
            if (i < reactions.size()) {
                ReactionData existing = (ReactionData)reactions.get(i);
                newMessageBuilder.reactions(ListUtil.remove(reactions, reaction -> reaction.equals(existing)));
            }
            return newMessageBuilder.build();
        }).flatMap(message -> this.stateHolder.getMessageStore().save(Long.valueOf(messageId), message));
    }

    private int indexOfReactionByEmojiData(List<ReactionData> reactions, EmojiData emojiData) {
        int i;
        for (i = 0; i < reactions.size(); ++i) {
            ReactionData r = reactions.get(i);
            boolean emojiHasId = emojiData.id().isPresent();
            if (emojiHasId && emojiData.id().equals(r.emoji().id()) || !emojiHasId && emojiData.name().equals(r.emoji().name())) break;
        }
        return i;
    }

    @Override
    public Mono<MessageData> onMessageUpdate(int shardIndex, MessageUpdate dispatch) {
        PartialMessageData messageData = dispatch.message();
        long messageId = Snowflake.asLong(messageData.id());
        return this.stateHolder.getMessageStore().find(messageId).flatMap(oldMessageData -> {
            boolean contentChanged = !messageData.content().isAbsent() && !Objects.equals(oldMessageData.content(), messageData.content().get());
            boolean embedsChanged = !Objects.equals(oldMessageData.embeds(), messageData.embeds());
            ImmutableMessageData newMessageData = MessageData.builder().from(oldMessageData).content(messageData.content().toOptional().orElse(oldMessageData.content())).embeds((Iterable)messageData.embeds()).mentions((Iterable)messageData.mentions()).mentionRoles((Iterable)messageData.mentionRoles()).mentionEveryone(messageData.mentionEveryone().toOptional().orElse(oldMessageData.mentionEveryone()).booleanValue()).editedTimestamp(messageData.editedTimestamp()).build();
            return this.stateHolder.getMessageStore().save(Long.valueOf(messageId), (Object)newMessageData).thenReturn(oldMessageData);
        });
    }

    @Override
    public Mono<PresenceAndUserData> onPresenceUpdate(int shardIndex, PresenceUpdate dispatch) {
        long guildId = Snowflake.asLong(dispatch.guildId());
        PartialUserData userData = dispatch.user();
        long userId = Snowflake.asLong(userData.id());
        LongLongTuple2 key = LongLongTuple2.of((long)guildId, (long)userId);
        ImmutablePresenceData presenceData = PresenceData.builder().user(dispatch.user()).status(dispatch.status()).activities((Iterable)dispatch.activities()).clientStatus(dispatch.clientStatus()).build();
        Mono saveNew = this.stateHolder.getPresenceStore().save((Comparable)key, (Object)presenceData);
        Mono savePresence = this.stateHolder.getPresenceStore().find((Comparable)key).flatMap(arg_0 -> ((Mono)saveNew).thenReturn(arg_0)).map(Optional::of).switchIfEmpty(saveNew.thenReturn(Optional.empty()));
        Mono saveUser = this.stateHolder.getUserStore().find(userId).flatMap(oldUserData -> {
            ImmutableUserData newUserData = UserData.builder().from(oldUserData).globalName(userData.globalName().isAbsent() ? oldUserData.globalName() : Possible.flatOpt((Possible)userData.globalName())).username(userData.username().toOptional().orElse(oldUserData.username())).discriminator(userData.discriminator().toOptional().orElse(oldUserData.discriminator())).avatar(userData.avatar().isAbsent() ? oldUserData.avatar() : Possible.flatOpt((Possible)userData.avatar())).build();
            return this.stateHolder.getUserStore().save(Long.valueOf(userId), (Object)newUserData).thenReturn(oldUserData);
        }).map(Optional::of).defaultIfEmpty(Optional.empty());
        return Mono.zip((Mono)savePresence, (Mono)saveUser, (p, u) -> PresenceAndUserData.of(p.orElse(null), u.orElse(null)));
    }

    @Override
    public Mono<Void> onReady(Ready dispatch) {
        UserData userData = dispatch.user();
        long userId = Snowflake.asLong(userData.id());
        return this.stateHolder.getUserStore().save(Long.valueOf(userId), (Object)userData);
    }

    @Override
    public Mono<UserData> onUserUpdate(int shardIndex, UserUpdate dispatch) {
        UserData userData = dispatch.user();
        long userId = Snowflake.asLong(userData.id());
        Mono saveNew = this.stateHolder.getUserStore().save(Long.valueOf(userId), (Object)userData);
        return this.stateHolder.getUserStore().find(userId).flatMap(arg_0 -> ((Mono)saveNew).thenReturn(arg_0)).switchIfEmpty(saveNew.then(Mono.empty()));
    }

    @Override
    public Mono<VoiceStateData> onVoiceStateUpdateDispatch(int shardIndex, VoiceStateUpdateDispatch dispatch) {
        VoiceStateData voiceStateData = dispatch.voiceState();
        long guildId = Snowflake.asLong((Id)voiceStateData.guildId().get());
        long userId = Snowflake.asLong(voiceStateData.userId());
        LongLongTuple2 key = LongLongTuple2.of((long)guildId, (long)userId);
        Mono saveNewOrRemove = voiceStateData.channelId().isPresent() ? this.stateHolder.getVoiceStateStore().save((Comparable)key, (Object)voiceStateData) : this.stateHolder.getVoiceStateStore().delete((Comparable)key);
        return this.stateHolder.getVoiceStateStore().find((Comparable)key).flatMap(arg_0 -> ((Mono)saveNewOrRemove).thenReturn(arg_0)).switchIfEmpty(saveNewOrRemove.then(Mono.empty()));
    }

    @Override
    public Mono<Void> onGuildMembersCompletion(long guildId) {
        return Mono.empty();
    }

    private static /* synthetic */ Tuple2 lambda$onGuildCreate$26(long guildId, GuildData guild, VoiceStateData voiceState) {
        return Tuples.of((Object)LongLongTuple2.of((long)guildId, (long)Snowflake.asLong(voiceState.userId())), (Object)VoiceStateData.builder().from(voiceState).guildId(guild.id()).build());
    }

    private static /* synthetic */ Tuple2 lambda$onGuildCreate$21(GuildData guild, ChannelData channel) {
        return Tuples.of((Object)Snowflake.asLong(channel.id()), (Object)ChannelData.builder().from(channel).guildId(guild.id()).build());
    }

    private static enum Type {
        UNKNOWN(-1),
        GUILD_TEXT(0),
        DM(1),
        GUILD_VOICE(2),
        GROUP_DM(3),
        GUILD_CATEGORY(4),
        GUILD_NEWS(5),
        GUILD_STORE(6),
        GUILD_STAGE_VOICE(13);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 0: {
                    return GUILD_TEXT;
                }
                case 1: {
                    return DM;
                }
                case 2: {
                    return GUILD_VOICE;
                }
                case 3: {
                    return GROUP_DM;
                }
                case 4: {
                    return GUILD_CATEGORY;
                }
                case 5: {
                    return GUILD_NEWS;
                }
                case 6: {
                    return GUILD_STORE;
                }
                case 13: {
                    return GUILD_STAGE_VOICE;
                }
            }
            return UNKNOWN;
        }
    }
}

