/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import discord4j.common.store.api.layout.DataAccessor;
import discord4j.common.store.api.layout.GatewayDataUpdater;
import discord4j.common.store.api.layout.StoreLayout;
import discord4j.common.store.api.object.ExactResultNotAvailableException;
import discord4j.common.store.api.object.InvalidationCause;
import discord4j.common.store.api.object.PresenceAndUserData;
import discord4j.common.store.impl.EmptyPartialUser;
import discord4j.common.store.impl.EmptyUser;
import discord4j.common.store.impl.ImplUtils;
import discord4j.common.store.impl.StorageBackend;
import discord4j.common.store.impl.StorageConfig;
import discord4j.common.store.impl.WithUser;
import discord4j.common.store.impl.WrappedGuildData;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildCreateData;
import discord4j.discordjson.json.GuildCreateFields;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildUpdateFields;
import discord4j.discordjson.json.ImmutableChannelData;
import discord4j.discordjson.json.ImmutableEmojiData;
import discord4j.discordjson.json.ImmutableGuildData;
import discord4j.discordjson.json.ImmutableMemberData;
import discord4j.discordjson.json.ImmutableMessageData;
import discord4j.discordjson.json.ImmutablePartialMessageData;
import discord4j.discordjson.json.ImmutablePartialUserData;
import discord4j.discordjson.json.ImmutablePresenceData;
import discord4j.discordjson.json.ImmutableReactionData;
import discord4j.discordjson.json.ImmutableRoleData;
import discord4j.discordjson.json.ImmutableUserData;
import discord4j.discordjson.json.ImmutableVoiceStateData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.PartialMessageData;
import discord4j.discordjson.json.PartialUserData;
import discord4j.discordjson.json.PresenceData;
import discord4j.discordjson.json.ReactionData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.gateway.ChannelCreate;
import discord4j.discordjson.json.gateway.ChannelDelete;
import discord4j.discordjson.json.gateway.ChannelUpdate;
import discord4j.discordjson.json.gateway.GuildCreate;
import discord4j.discordjson.json.gateway.GuildDelete;
import discord4j.discordjson.json.gateway.GuildEmojisUpdate;
import discord4j.discordjson.json.gateway.GuildMemberAdd;
import discord4j.discordjson.json.gateway.GuildMemberRemove;
import discord4j.discordjson.json.gateway.GuildMemberUpdate;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.GuildRoleCreate;
import discord4j.discordjson.json.gateway.GuildRoleDelete;
import discord4j.discordjson.json.gateway.GuildRoleUpdate;
import discord4j.discordjson.json.gateway.GuildUpdate;
import discord4j.discordjson.json.gateway.MessageCreate;
import discord4j.discordjson.json.gateway.MessageDelete;
import discord4j.discordjson.json.gateway.MessageDeleteBulk;
import discord4j.discordjson.json.gateway.MessageReactionAdd;
import discord4j.discordjson.json.gateway.MessageReactionRemove;
import discord4j.discordjson.json.gateway.MessageReactionRemoveAll;
import discord4j.discordjson.json.gateway.MessageReactionRemoveEmoji;
import discord4j.discordjson.json.gateway.MessageUpdate;
import discord4j.discordjson.json.gateway.PresenceUpdate;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.discordjson.json.gateway.UserUpdate;
import discord4j.discordjson.json.gateway.VoiceStateUpdateDispatch;
import discord4j.discordjson.possible.Possible;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class LocalStoreLayout
implements StoreLayout,
DataAccessor,
GatewayDataUpdater {
    private final StorageConfig config;
    private final ConcurrentMap<Long, GuildContent> contentByGuild = new ConcurrentHashMap<Long, GuildContent>();
    private final ConcurrentMap<Long, ChannelContent> contentByChannel = new ConcurrentHashMap<Long, ChannelContent>();
    private final ConcurrentMap<Long, ImmutableChannelData> channels = new ConcurrentHashMap<Long, ImmutableChannelData>();
    private final ConcurrentMap<Long, WithUser<ImmutableEmojiData>> emojis = new ConcurrentHashMap<Long, WithUser<ImmutableEmojiData>>();
    private final ConcurrentMap<Long, WrappedGuildData> guilds = new ConcurrentHashMap<Long, WrappedGuildData>();
    private final ConcurrentMap<Long2, WithUser<ImmutableMemberData>> members = new ConcurrentHashMap<Long2, WithUser<ImmutableMemberData>>();
    private final ConcurrentMap<Long2, WithUser<ImmutableMessageData>> messages;
    private final ConcurrentMap<Long2, WithUser<ImmutablePresenceData>> presences = new ConcurrentHashMap<Long2, WithUser<ImmutablePresenceData>>();
    private final ConcurrentMap<Long, RoleData> roles = new ConcurrentHashMap<Long, RoleData>();
    private final ConcurrentMap<Long, AtomicReference<ImmutableUserData>> users = StorageBackend.caffeine(Caffeine::weakValues).newMap();
    private final ConcurrentMap<Long2, ImmutableVoiceStateData> voiceStates = new ConcurrentHashMap<Long2, ImmutableVoiceStateData>();
    private final Set<Integer> shardsConnected = new HashSet<Integer>();
    private volatile AtomicReference<ImmutableUserData> selfUser;
    private volatile int shardCount;

    private LocalStoreLayout(StorageConfig config) {
        this.messages = config.getMessageBackend().newMap((k, v, reason) -> {
            if (k != null && reason.wasEvicted()) {
                ImplUtils.ifNonNullDo((ChannelContent)this.contentByChannel.get(((Long2)k).a), content -> ((ChannelContent)content).messageIds.remove(k));
            }
        });
        this.config = config;
    }

    public static LocalStoreLayout create(StorageConfig config) {
        return new LocalStoreLayout(config);
    }

    public static LocalStoreLayout create() {
        return LocalStoreLayout.create(StorageConfig.builder().build());
    }

    @Override
    public Mono<Long> countChannels() {
        return Mono.just((Object)this.channels.size());
    }

    @Override
    public Mono<Long> countChannelsInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).map(content -> ((GuildContent)content).channelIds.size());
    }

    @Override
    public Mono<Long> countEmojis() {
        return Mono.just((Object)this.emojis.size());
    }

    @Override
    public Mono<Long> countEmojisInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).map(content -> ((GuildContent)content).emojiIds.size());
    }

    @Override
    public Mono<Long> countGuilds() {
        return Mono.just((Object)this.guilds.size());
    }

    @Override
    public Mono<Long> countMembers() {
        return Mono.just((Object)this.members.size());
    }

    @Override
    public Mono<Long> countMembersInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).map(content -> ((GuildContent)content).memberIds.size());
    }

    @Override
    public Mono<Long> countExactMembersInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).filter(rec$ -> ((GuildContent)rec$).isMemberListComplete()).switchIfEmpty(Mono.error(ExactResultNotAvailableException::new)).map(content -> ((GuildContent)content).memberIds.size());
    }

    @Override
    public Mono<Long> countMessages() {
        return Mono.just((Object)this.messages.size());
    }

    @Override
    public Mono<Long> countMessagesInChannel(long channelId) {
        return Mono.justOrEmpty((Object)((ChannelContent)this.contentByChannel.get(channelId))).map(content -> ((ChannelContent)content).messageIds.size());
    }

    @Override
    public Mono<Long> countPresences() {
        return Mono.just((Object)this.presences.size());
    }

    @Override
    public Mono<Long> countPresencesInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).map(content -> ((GuildContent)content).presenceIds.size());
    }

    @Override
    public Mono<Long> countRoles() {
        return Mono.just((Object)this.roles.size());
    }

    @Override
    public Mono<Long> countRolesInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).map(content -> ((GuildContent)content).roleIds.size());
    }

    @Override
    public Mono<Long> countUsers() {
        return Mono.just((Object)this.users.size());
    }

    @Override
    public Mono<Long> countVoiceStates() {
        return Mono.just((Object)this.voiceStates.size());
    }

    @Override
    public Mono<Long> countVoiceStatesInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).map(content -> ((GuildContent)content).voiceStateIds.size());
    }

    @Override
    public Mono<Long> countVoiceStatesInChannel(long guildId, long channelId) {
        return Mono.justOrEmpty((Object)((ChannelContent)this.contentByChannel.get(channelId))).map(content -> ((ChannelContent)content).voiceStateIds.size());
    }

    @Override
    public Flux<ChannelData> getChannels() {
        return Flux.fromIterable(this.channels.values());
    }

    @Override
    public Flux<ChannelData> getChannelsInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).flatMapIterable(content -> ((GuildContent)content).channelIds).flatMap(id -> Mono.justOrEmpty((Object)((ImmutableChannelData)this.channels.get(id))));
    }

    @Override
    public Mono<ChannelData> getChannelById(long channelId) {
        return Mono.justOrEmpty((Object)((ChannelData)this.channels.get(channelId)));
    }

    @Override
    public Flux<EmojiData> getEmojis() {
        return Flux.fromIterable(this.emojis.values()).map(WithUser::get);
    }

    @Override
    public Flux<EmojiData> getEmojisInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).flatMapIterable(content -> ((GuildContent)content).emojiIds).flatMap(id -> Mono.justOrEmpty((Object)((WithUser)this.emojis.get(id)))).map(WithUser::get);
    }

    @Override
    public Mono<EmojiData> getEmojiById(long guildId, long emojiId) {
        return Mono.justOrEmpty((Object)((WithUser)this.emojis.get(emojiId))).map(WithUser::get);
    }

    @Override
    public Flux<GuildData> getGuilds() {
        return Flux.fromIterable(this.guilds.values()).map(WrappedGuildData::unwrap);
    }

    @Override
    public Mono<GuildData> getGuildById(long guildId) {
        return Mono.justOrEmpty((Object)((WrappedGuildData)this.guilds.get(guildId))).map(WrappedGuildData::unwrap);
    }

    @Override
    public Flux<MemberData> getMembers() {
        return Flux.fromIterable(this.members.values()).map(WithUser::get);
    }

    @Override
    public Flux<MemberData> getMembersInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).flatMapIterable(content -> ((GuildContent)content).memberIds).flatMap(id -> Mono.justOrEmpty((Object)((WithUser)this.members.get(id)))).map(WithUser::get);
    }

    @Override
    public Flux<MemberData> getExactMembersInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).filter(rec$ -> ((GuildContent)rec$).isMemberListComplete()).switchIfEmpty(Mono.error(ExactResultNotAvailableException::new)).flatMapIterable(content -> ((GuildContent)content).memberIds).flatMap(id -> Mono.justOrEmpty((Object)((WithUser)this.members.get(id)))).map(WithUser::get);
    }

    @Override
    public Mono<MemberData> getMemberById(long guildId, long userId) {
        return Mono.justOrEmpty((Object)((WithUser)this.members.get(new Long2(guildId, userId)))).map(WithUser::get);
    }

    @Override
    public Flux<MessageData> getMessages() {
        return Flux.fromIterable(this.messages.values()).map(WithUser::get);
    }

    @Override
    public Flux<MessageData> getMessagesInChannel(long channelId) {
        return Mono.justOrEmpty((Object)((ChannelContent)this.contentByChannel.get(channelId))).flatMapIterable(content -> ((ChannelContent)content).messageIds).flatMap(id -> Mono.justOrEmpty((Object)((WithUser)this.messages.get(id)))).map(WithUser::get);
    }

    @Override
    public Mono<MessageData> getMessageById(long channelId, long messageId) {
        return Mono.justOrEmpty((Object)((WithUser)this.messages.get(new Long2(channelId, messageId)))).map(WithUser::get);
    }

    @Override
    public Flux<PresenceData> getPresences() {
        return Flux.fromIterable(this.presences.values()).map(WithUser::get);
    }

    @Override
    public Flux<PresenceData> getPresencesInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).flatMapIterable(content -> ((GuildContent)content).presenceIds).flatMap(id -> Mono.justOrEmpty((Object)((WithUser)this.presences.get(id)))).map(WithUser::get);
    }

    @Override
    public Mono<PresenceData> getPresenceById(long guildId, long userId) {
        return Mono.justOrEmpty((Object)((WithUser)this.presences.get(new Long2(guildId, userId)))).map(WithUser::get);
    }

    @Override
    public Flux<RoleData> getRoles() {
        return Flux.fromIterable(this.roles.values());
    }

    @Override
    public Flux<RoleData> getRolesInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).flatMapIterable(content -> ((GuildContent)content).roleIds).flatMap(id -> Mono.justOrEmpty((Object)((RoleData)this.roles.get(id))));
    }

    @Override
    public Mono<RoleData> getRoleById(long guildId, long roleId) {
        return Mono.justOrEmpty((Object)((RoleData)this.roles.get(roleId)));
    }

    @Override
    public Flux<UserData> getUsers() {
        return Flux.fromIterable(this.users.values()).map(AtomicReference::get);
    }

    @Override
    public Mono<UserData> getUserById(long userId) {
        return Mono.justOrEmpty((Object)((AtomicReference)this.users.get(userId))).map(AtomicReference::get);
    }

    @Override
    public Flux<VoiceStateData> getVoiceStates() {
        return Flux.fromIterable(this.voiceStates.values());
    }

    @Override
    public Flux<VoiceStateData> getVoiceStatesInChannel(long guildId, long channelId) {
        return Mono.justOrEmpty((Object)((ChannelContent)this.contentByChannel.get(channelId))).flatMapIterable(content -> ((ChannelContent)content).voiceStateIds).flatMap(id -> Mono.justOrEmpty((Object)((ImmutableVoiceStateData)this.voiceStates.get(id))));
    }

    @Override
    public Flux<VoiceStateData> getVoiceStatesInGuild(long guildId) {
        return Mono.justOrEmpty((Object)((GuildContent)this.contentByGuild.get(guildId))).flatMapIterable(content -> ((GuildContent)content).voiceStateIds).flatMap(id -> Mono.justOrEmpty((Object)((ImmutableVoiceStateData)this.voiceStates.get(id))));
    }

    @Override
    public Mono<VoiceStateData> getVoiceStateById(long guildId, long userId) {
        return Mono.justOrEmpty((Object)((VoiceStateData)this.voiceStates.get(new Long2(guildId, userId))));
    }

    @Override
    public Mono<Void> onChannelCreate(int shardIndex, ChannelCreate dispatch) {
        return Mono.fromRunnable(() -> dispatch.channel().guildId().toOptional().ifPresent(guildId -> this.saveChannel(guildId.asLong(), dispatch.channel())));
    }

    @Override
    public Mono<ChannelData> onChannelDelete(int shardIndex, ChannelDelete dispatch) {
        ChannelData data = dispatch.channel();
        return Mono.fromRunnable(() -> data.guildId().toOptional().map(Id::asLong).ifPresent(guildId -> {
            Id channelId = data.id();
            GuildContent guildContent = this.computeGuildContent((long)guildId);
            guildContent.channelIds.remove(channelId.asLong());
            ImplUtils.ifNonNullDo((ChannelContent)this.contentByChannel.get(channelId.asLong()), rec$ -> ((ChannelContent)rec$).dispose());
            ImplUtils.ifNonNullDo((WrappedGuildData)this.guilds.get(guildId), guild -> guild.getChannels().remove(channelId));
        })).thenReturn((Object)data);
    }

    @Override
    public Mono<ChannelData> onChannelUpdate(int shardIndex, ChannelUpdate dispatch) {
        return Mono.fromCallable(() -> dispatch.channel().guildId().toOptional().map(guildId -> this.saveChannel(guildId.asLong(), dispatch.channel())).orElse(null));
    }

    @Override
    public Mono<Void> onGuildCreate(int shardIndex, GuildCreate dispatch) {
        return Mono.fromRunnable(() -> {
            long guildId = dispatch.guild().id().asLong();
            GuildCreateData createData = dispatch.guild();
            List roles = createData.roles();
            List emojis = createData.emojis();
            List members = createData.members();
            List channels = createData.channels();
            List presences = createData.presences();
            List voiceStates = createData.voiceStates();
            ImmutableGuildData guild = ImmutableGuildData.builder().from((GuildCreateFields)createData).roles(Collections.emptyList()).emojis(Collections.emptyList()).members(Collections.emptyList()).channels(Collections.emptyList()).build();
            this.guilds.put(guildId, new WrappedGuildData(guild));
            roles.forEach(role -> this.saveRole(guildId, (RoleData)role));
            emojis.forEach(emoji -> this.saveEmoji(guildId, (EmojiData)emoji));
            members.forEach(member -> this.saveMember(guildId, (MemberData)member));
            channels.forEach(channel -> this.saveChannel(guildId, (ChannelData)channel));
            presences.forEach(presence -> this.savePresence(guildId, (PresenceData)presence));
            voiceStates.forEach(voiceState -> this.saveOrRemoveVoiceState(guildId, (VoiceStateData)voiceState));
        });
    }

    @Override
    public Mono<GuildData> onGuildDelete(int shardIndex, GuildDelete dispatch) {
        long guildId = dispatch.guild().id().asLong();
        return Mono.fromCallable(() -> ImplUtils.ifNonNullMap(this.contentByGuild.get(guildId), rec$ -> ((GuildContent)rec$).dispose()));
    }

    @Override
    public Mono<Set<EmojiData>> onGuildEmojisUpdate(int shardIndex, GuildEmojisUpdate dispatch) {
        long guildId = dispatch.guildId().asLong();
        return Mono.fromCallable(() -> {
            GuildContent content = this.computeGuildContent(guildId);
            Set old = content.emojiIds.stream().map(this.emojis::get).filter(Objects::nonNull).map(WithUser::get).collect(Collectors.toSet());
            this.emojis.keySet().removeAll(content.emojiIds);
            ImplUtils.ifNonNullDo((WrappedGuildData)this.guilds.get(guildId), guild -> guild.getEmojis().clear());
            content.emojiIds.clear();
            dispatch.emojis().forEach(emoji -> this.saveEmoji(guildId, (EmojiData)emoji));
            return old;
        });
    }

    @Override
    public Mono<Void> onGuildMemberAdd(int shardIndex, GuildMemberAdd dispatch) {
        return Mono.fromRunnable(() -> this.saveMember(dispatch.guildId().asLong(), dispatch.member()));
    }

    @Override
    public Mono<MemberData> onGuildMemberRemove(int shardIndex, GuildMemberRemove dispatch) {
        long guildId = dispatch.guildId().asLong();
        long userId = dispatch.user().id().asLong();
        return Mono.fromCallable(() -> {
            Long2 memberId = new Long2(guildId, userId);
            GuildContent guildContent = this.computeGuildContent(guildId);
            guildContent.memberIds.remove(memberId);
            ImplUtils.ifNonNullDo((WrappedGuildData)this.guilds.get(guildId), guild -> guild.getMembers().remove(Id.of((long)memberId.b)));
            return (MemberData)ImplUtils.ifNonNullMap((WithUser)this.members.remove(memberId), WithUser::get);
        });
    }

    @Override
    public Mono<Void> onGuildMembersChunk(int shardIndex, GuildMembersChunk dispatch) {
        long guildId = dispatch.guildId().asLong();
        return Mono.fromRunnable(() -> dispatch.members().forEach(member -> this.saveMember(guildId, (MemberData)member)));
    }

    @Override
    public Mono<MemberData> onGuildMemberUpdate(int shardIndex, GuildMemberUpdate dispatch) {
        long guildId = dispatch.guildId().asLong();
        long userId = dispatch.user().id().asLong();
        Long2 id = new Long2(guildId, userId);
        return Mono.fromCallable(() -> {
            MemberData oldData = (MemberData)ImplUtils.ifNonNullMap((WithUser)this.members.get(id), WithUser::get);
            this.members.computeIfPresent(id, (k, old) -> {
                AtomicReference<ImmutableUserData> ref = old.userRef();
                if (ref != null) {
                    ref.set(ImmutableUserData.copyOf((UserData)dispatch.user()));
                }
                return new WithUser<ImmutableMemberData>(ImmutableMemberData.builder().from((MemberData)old.get()).nick(dispatch.nick()).roles(dispatch.roles().stream().map(Id::of).collect(Collectors.toList())).joinedAt(dispatch.joinedAt()).premiumSince(dispatch.premiumSince()).build(), ref, ImmutableMemberData::withUser);
            });
            return oldData;
        });
    }

    @Override
    public Mono<Void> onGuildRoleCreate(int shardIndex, GuildRoleCreate dispatch) {
        return Mono.fromRunnable(() -> this.saveRole(dispatch.guildId().asLong(), dispatch.role()));
    }

    @Override
    public Mono<RoleData> onGuildRoleDelete(int shardIndex, GuildRoleDelete dispatch) {
        long guildId = dispatch.guildId().asLong();
        Id roleId = dispatch.roleId();
        return Mono.fromCallable(() -> {
            GuildContent guildContent = this.computeGuildContent(guildId);
            guildContent.roleIds.remove(roleId.asLong());
            ImplUtils.ifNonNullDo((WrappedGuildData)this.guilds.get(guildId), guild -> guild.getRoles().remove(roleId));
            guildContent.memberIds.forEach(id2 -> this.members.computeIfPresent((Long2)id2, (k, member) -> member.update(m -> m.withRoles(ImplUtils.remove(m.roles(), roleId)))));
            return (RoleData)this.roles.remove(roleId.asLong());
        });
    }

    @Override
    public Mono<RoleData> onGuildRoleUpdate(int shardIndex, GuildRoleUpdate dispatch) {
        return Mono.fromCallable(() -> this.saveRole(dispatch.guildId().asLong(), dispatch.role()));
    }

    @Override
    public Mono<GuildData> onGuildUpdate(int shardIndex, GuildUpdate dispatch) {
        long guildId = dispatch.guild().id().asLong();
        return Mono.fromCallable(() -> {
            WrappedGuildData old = (WrappedGuildData)this.guilds.get(guildId);
            this.guilds.computeIfPresent(guildId, (k, oldGuild) -> new WrappedGuildData(GuildData.builder().from((GuildData)oldGuild.unwrap()).from((GuildUpdateFields)dispatch.guild()).build()));
            return (GuildData)ImplUtils.ifNonNullMap(old, WrappedGuildData::unwrap);
        });
    }

    @Override
    public Mono<Void> onShardInvalidation(int shardIndex, InvalidationCause cause) {
        return Mono.fromRunnable(() -> {
            this.shardsConnected.remove(shardIndex);
            if (this.config.getInvalidationFilter().contains((Object)cause)) {
                this.contentByGuild.entrySet().stream().filter(entry -> ((Long)entry.getKey() >> 22) % (long)this.shardCount == (long)shardIndex).map(Map.Entry::getValue).forEach(rec$ -> ((GuildContent)rec$).dispose());
            }
            if (this.shardsConnected.isEmpty()) {
                this.shardCount = 0;
            }
        });
    }

    @Override
    public Mono<Void> onMessageCreate(int shardIndex, MessageCreate dispatch) {
        ImmutableMessageData message = ImmutableMessageData.copyOf((MessageData)dispatch.message());
        long channelId = message.channelId().asLong();
        long messageId = message.id().asLong();
        Long2 id = new Long2(channelId, messageId);
        return Mono.fromRunnable(() -> {
            ChannelContent channelContent = this.computeChannelContent(id.a);
            this.channels.computeIfPresent(id.a, (k, channel) -> channel.withLastMessageIdOrNull(Long.valueOf(id.b)));
            channelContent.messageIds.add(id);
            AtomicReference<ImmutableUserData> userRef = this.computeUserRef(message.author().id().asLong(), message, (m, old) -> ImmutableUserData.copyOf((UserData)m.author()));
            this.messages.put(id, new WithUser<ImmutableMessageData>(message.withAuthor((UserData)EmptyUser.INSTANCE), userRef, ImmutableMessageData::withAuthor));
        });
    }

    @Override
    public Mono<MessageData> onMessageDelete(int shardIndex, MessageDelete dispatch) {
        long messageId = dispatch.id().asLong();
        long channelId = dispatch.channelId().asLong();
        return Mono.fromCallable(() -> this.deleteMessage(channelId, messageId));
    }

    @Override
    public Mono<Set<MessageData>> onMessageDeleteBulk(int shardIndex, MessageDeleteBulk dispatch) {
        return Mono.fromCallable(() -> dispatch.ids().stream().map(Id::asLong).map(messageId -> this.deleteMessage(dispatch.channelId().asLong(), (long)messageId)).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    @Override
    public Mono<Void> onMessageReactionAdd(int shardIndex, MessageReactionAdd dispatch) {
        long channelId = dispatch.channelId().asLong();
        long messageId = dispatch.messageId().asLong();
        return Mono.fromRunnable(() -> this.messages.computeIfPresent(new Long2(channelId, messageId), (k, message) -> message.update(m -> this.addReaction((ImmutableMessageData)m, dispatch))));
    }

    @Override
    public Mono<Void> onMessageReactionRemove(int shardIndex, MessageReactionRemove dispatch) {
        long channelId = dispatch.channelId().asLong();
        long messageId = dispatch.messageId().asLong();
        return Mono.fromRunnable(() -> this.messages.computeIfPresent(new Long2(channelId, messageId), (k, message) -> message.update(m -> this.removeReaction((ImmutableMessageData)m, dispatch))));
    }

    @Override
    public Mono<Void> onMessageReactionRemoveAll(int shardIndex, MessageReactionRemoveAll dispatch) {
        long channelId = dispatch.channelId().asLong();
        long messageId = dispatch.messageId().asLong();
        return Mono.fromRunnable(() -> this.messages.computeIfPresent(new Long2(channelId, messageId), (k, message) -> message.update(m -> m.withReactions(Possible.absent()))));
    }

    @Override
    public Mono<Void> onMessageReactionRemoveEmoji(int shardIndex, MessageReactionRemoveEmoji dispatch) {
        long channelId = dispatch.channelId().asLong();
        long messageId = dispatch.messageId().asLong();
        return Mono.fromRunnable(() -> this.messages.computeIfPresent(new Long2(channelId, messageId), (k, message) -> message.update(m -> m.withReactions(Possible.of(m.reactions().toOptional().orElse(Collections.emptyList()).stream().filter(r -> !EmojiKey.predicateEquals(dispatch.emoji()).test(r)).collect(Collectors.toList()))))));
    }

    @Override
    public Mono<MessageData> onMessageUpdate(int shardIndex, MessageUpdate dispatch) {
        ImmutablePartialMessageData edited = ImmutablePartialMessageData.copyOf((PartialMessageData)dispatch.message());
        long channelId = edited.channelId().asLong();
        long messageId = edited.id().asLong();
        Long2 id = new Long2(channelId, messageId);
        return Mono.fromCallable(() -> {
            MessageData old = (MessageData)ImplUtils.ifNonNullMap((WithUser)this.messages.get(id), WithUser::get);
            this.messages.computeIfPresent(id, (k, message) -> message.update(m -> ImmutableMessageData.builder().from((MessageData)m).channelId(edited.channelId()).guildId(edited.guildId()).content(edited.contentOrElse(m.content())).timestamp(edited.timestampOrElse(m.timestamp())).editedTimestamp(edited.editedTimestamp()).tts(edited.ttsOrElse(Boolean.valueOf(m.tts())).booleanValue()).mentionEveryone(edited.mentionEveryoneOrElse(Boolean.valueOf(m.mentionEveryone())).booleanValue()).mentions((Iterable)edited.mentions()).mentionRoles((Iterable)edited.mentionRoles()).mentionChannels(edited.mentionChannels()).attachments((Iterable)edited.attachments()).embeds((Iterable)edited.embeds()).nonce(edited.nonceOrElse((Object)m.nonce())).pinned(edited.pinnedOrElse(Boolean.valueOf(m.pinned())).booleanValue()).webhookId(edited.isWebhookIdPresent() ? edited.webhookId() : m.webhookId()).type(edited.typeOrElse(Integer.valueOf(m.type())).intValue()).activity(edited.isActivityPresent() ? edited.activity() : m.activity()).application(edited.isApplicationPresent() ? edited.application() : m.application()).messageReference(edited.isMessageReferencePresent() ? edited.messageReference() : m.messageReference()).flags(edited.isFlagsPresent() ? edited.flags() : m.flags()).reactions(edited.isReactionsPresent() ? edited.reactions() : m.reactions()).build()));
            return old;
        });
    }

    @Override
    public Mono<PresenceAndUserData> onPresenceUpdate(int shardIndex, PresenceUpdate dispatch) {
        return Mono.fromCallable(() -> this.savePresence(dispatch.guildId().asLong(), ImplUtils.createPresence(dispatch)));
    }

    @Override
    public Mono<Void> onReady(Ready dispatch) {
        return Mono.fromRunnable(() -> {
            int[] shardInfo = dispatch.shard().toOptional().orElseGet(() -> new int[]{0, 1});
            if (this.selfUser == null) {
                ImmutableUserData userData = ImmutableUserData.copyOf((UserData)dispatch.user());
                this.selfUser = new AtomicReference<ImmutableUserData>(userData);
                this.users.put(userData.id().asLong(), this.selfUser);
            }
            if (this.shardCount == 0) {
                this.shardCount = shardInfo[1];
            }
            this.shardsConnected.add(shardInfo[0]);
        });
    }

    @Override
    public Mono<UserData> onUserUpdate(int shardIndex, UserUpdate dispatch) {
        return Mono.fromCallable(() -> (UserData)ImplUtils.ifNonNullMap((AtomicReference)this.users.get(dispatch.user().id().asLong()), userRef -> userRef.getAndSet(ImmutableUserData.copyOf((UserData)dispatch.user()))));
    }

    @Override
    public Mono<VoiceStateData> onVoiceStateUpdateDispatch(int shardIndex, VoiceStateUpdateDispatch dispatch) {
        VoiceStateData voiceState = dispatch.voiceState();
        return Mono.justOrEmpty((Optional)voiceState.guildId().toOptional()).map(Id::asLong).flatMap(guildId -> Mono.fromCallable(() -> this.saveOrRemoveVoiceState((long)guildId, voiceState)));
    }

    @Override
    public Mono<Void> onGuildMembersCompletion(long guildId) {
        return Mono.fromRunnable(() -> ImplUtils.ifNonNullDo((GuildContent)this.contentByGuild.get(guildId), rec$ -> ((GuildContent)rec$).completeMemberList()));
    }

    @Override
    public DataAccessor getDataAccessor() {
        return this;
    }

    @Override
    public GatewayDataUpdater getGatewayDataUpdater() {
        return this;
    }

    private GuildContent computeGuildContent(long guildId) {
        return this.contentByGuild.computeIfAbsent(guildId, x$0 -> new GuildContent((long)x$0));
    }

    private ChannelContent computeChannelContent(long channelId) {
        return this.contentByChannel.computeIfAbsent(channelId, x$0 -> new ChannelContent((long)x$0));
    }

    @Nullable
    private ChannelData saveChannel(long guildId, ChannelData channel) {
        long channelId = channel.id().asLong();
        GuildContent guildContent = this.computeGuildContent(guildId);
        guildContent.channelIds.add(channelId);
        ImplUtils.ifNonNullDo((WrappedGuildData)this.guilds.get(guildId), guild -> guild.getChannels().add(Id.of((long)channelId)));
        return (ChannelData)this.channels.put(channelId, ImmutableChannelData.copyOf((ChannelData)channel).withGuildId(guildId));
    }

    @Nullable
    private RoleData saveRole(long guildId, RoleData role) {
        long roleId = role.id().asLong();
        GuildContent guildContent = this.computeGuildContent(guildId);
        guildContent.roleIds.add(roleId);
        ImplUtils.ifNonNullDo((WrappedGuildData)this.guilds.get(guildId), guild -> guild.getRoles().add(Id.of((long)roleId)));
        return this.roles.put(roleId, (RoleData)ImmutableRoleData.copyOf((RoleData)role));
    }

    private void saveEmoji(long guildId, EmojiData emoji) {
        emoji.id().map(Id::asLong).ifPresent(emojiId -> {
            this.computeGuildContent(guildId).emojiIds.add(emojiId);
            ImplUtils.ifNonNullDo((WrappedGuildData)this.guilds.get(guildId), guild -> guild.getEmojis().add(Id.of((long)emojiId)));
            AtomicReference userRef = ImplUtils.ifNonNullMap(emoji.user().toOptional().map(user -> user.id().asLong()).orElse(null), userId -> this.computeUserRef((long)userId, (Object)emoji, (e, u) -> ImmutableUserData.copyOf((UserData)((UserData)e.user().get()))));
            this.emojis.put((Long)emojiId, new WithUser<ImmutableEmojiData>(ImmutableEmojiData.copyOf((EmojiData)emoji).withUser(Possible.absent()), userRef, (e, u) -> e.withUser(Possible.of((Object)u))));
        });
    }

    private void saveMember(long guildId, MemberData member) {
        Long2 memberId = new Long2(guildId, member.user().id().asLong());
        GuildContent guildContent = this.computeGuildContent(guildId);
        guildContent.memberIds.add(memberId);
        ImplUtils.ifNonNullDo((WrappedGuildData)this.guilds.get(guildId), guild -> guild.getMembers().add(Id.of((long)memberId.b)));
        AtomicReference<ImmutableUserData> userRef = this.computeUserRef(memberId.b, member, (m, u) -> ImmutableUserData.copyOf((UserData)m.user()));
        this.members.put(memberId, new WithUser<ImmutableMemberData>(ImmutableMemberData.copyOf((MemberData)member).withUser((UserData)EmptyUser.INSTANCE), userRef, ImmutableMemberData::withUser));
    }

    @Nullable
    private PresenceAndUserData savePresence(long guildId, PresenceData presence) {
        Long2 presenceId = new Long2(guildId, presence.user().id().asLong());
        ImmutableUserData oldUser = ImplUtils.ifNonNullMap((AtomicReference)this.users.get(presenceId.b), AtomicReference::get);
        return ImplUtils.ifNonNullMap(this.computeUserRef(presenceId.b, presence, LocalStoreLayout::userFromPresence), userRef -> {
            GuildContent guildContent = this.computeGuildContent(guildId);
            guildContent.presenceIds.add(presenceId);
            WithUser<ImmutablePresenceData> oldPresence = this.presences.put(presenceId, new WithUser<ImmutablePresenceData>(ImmutablePresenceData.copyOf((PresenceData)presence).withUser((PartialUserData)EmptyPartialUser.INSTANCE), (AtomicReference<ImmutableUserData>)userRef, (p, u) -> p.withUser((PartialUserData)PartialUserData.builder().id(u.id()).avatar(Possible.of((Object)u.avatar())).username(u.username()).discriminator(u.discriminator()).build())));
            if (oldPresence == null && oldUser == null) {
                return null;
            }
            return PresenceAndUserData.of((PresenceData)ImplUtils.ifNonNullMap(oldPresence, WithUser::get), (UserData)oldUser);
        });
    }

    @Nullable
    private static ImmutableUserData userFromPresence(PresenceData newPresence, @Nullable ImmutableUserData oldUser) {
        if (oldUser == null) {
            return null;
        }
        ImmutablePartialUserData partialUserData = ImmutablePartialUserData.copyOf((PartialUserData)newPresence.user());
        return UserData.builder().from((UserData)oldUser).username(partialUserData.usernameOrElse(oldUser.username())).discriminator(partialUserData.discriminatorOrElse(oldUser.discriminator())).avatar(ImplUtils.or(Possible.flatOpt((Possible)partialUserData.avatar()), () -> ((ImmutableUserData)oldUser).avatar())).banner(Possible.of(ImplUtils.or(Possible.flatOpt((Possible)partialUserData.banner()), () -> Possible.flatOpt((Possible)oldUser.banner())))).accentColor(Possible.of(ImplUtils.or(Possible.flatOpt((Possible)partialUserData.accentColor()), () -> Possible.flatOpt((Possible)oldUser.accentColor())))).build();
    }

    @Nullable
    private VoiceStateData saveOrRemoveVoiceState(long guildId, VoiceStateData voiceState) {
        Long2 voiceStateId = new Long2(guildId, voiceState.userId().asLong());
        GuildContent guildContent = this.computeGuildContent(guildId);
        if (voiceState.channelId().isPresent()) {
            guildContent.voiceStateIds.add(voiceStateId);
            this.computeChannelContent(((Id)voiceState.channelId().get()).asLong()).voiceStateIds.add(voiceStateId);
            return (VoiceStateData)this.voiceStates.put(voiceStateId, ImmutableVoiceStateData.copyOf((VoiceStateData)voiceState).withGuildId(guildId).withMember(Possible.absent()));
        }
        guildContent.voiceStateIds.remove(voiceStateId);
        VoiceStateData old = (VoiceStateData)this.voiceStates.remove(voiceStateId);
        if (old != null && old.channelId().isPresent()) {
            this.computeChannelContent(((Id)old.channelId().get()).asLong()).voiceStateIds.remove(voiceStateId);
        }
        return old;
    }

    @Nullable
    private MessageData deleteMessage(long channelId, long messageId) {
        Long2 id = new Long2(channelId, messageId);
        ChannelContent channelContent = this.computeChannelContent(channelId);
        channelContent.messageIds.remove(id);
        return (MessageData)ImplUtils.ifNonNullMap((WithUser)this.messages.remove(id), WithUser::get);
    }

    private ImmutableMessageData addReaction(ImmutableMessageData message, MessageReactionAdd dispatch) {
        boolean me = dispatch.userId().asLong() == this.selfUser.get().id().asLong();
        List reactions = message.reactions().toOptional().orElse(Collections.emptyList());
        if (reactions.stream().anyMatch(EmojiKey.predicateEquals(dispatch.emoji()))) {
            return message.withReactions(Possible.of(reactions.stream().map(r -> EmojiKey.predicateEquals(dispatch.emoji()).test(r) ? ImmutableReactionData.builder().from(r).count(r.count() + 1).me(r.me() || me).build() : r).collect(Collectors.toList())));
        }
        return message.withReactions(Possible.of(ImplUtils.add(reactions, ImmutableReactionData.of((int)1, (boolean)me, (EmojiData)dispatch.emoji()))));
    }

    private ImmutableMessageData removeReaction(ImmutableMessageData message, MessageReactionRemove dispatch) {
        boolean me = dispatch.userId().asLong() == this.selfUser.get().id().asLong();
        List reactions = message.reactions().toOptional().orElse(Collections.emptyList());
        return message.withReactions(Possible.of(reactions.stream().map(r -> EmojiKey.predicateEquals(dispatch.emoji()).test(r) ? ImmutableReactionData.builder().from(r).count(r.count() - 1).me(!me && r.me()).build() : r).filter(r -> r.count() > 0).collect(Collectors.toList())));
    }

    @Nullable
    private <T> AtomicReference<ImmutableUserData> computeUserRef(long userId, T newData, BiFunction<T, ImmutableUserData, ImmutableUserData> userUpdater) {
        AtomicReference<ImmutableUserData> ref;
        while (true) {
            AtomicReference<ImmutableUserData> existing;
            if ((existing = (AtomicReference<ImmutableUserData>)this.users.get(userId)) == null) {
                ImmutableUserData newUser = userUpdater.apply(newData, null);
                if (newUser == null) {
                    return null;
                }
                ref = new AtomicReference<ImmutableUserData>(newUser);
                if (this.users.putIfAbsent(userId, ref) == null) break;
                continue;
            }
            ref = existing;
            ImmutableUserData oldUser = (ImmutableUserData)ref.get();
            ImmutableUserData newUser = userUpdater.apply(newData, oldUser);
            if (newUser == null || ref.compareAndSet(oldUser, newUser)) break;
        }
        return ref;
    }

    private class ChannelContent {
        private final long channelId;
        private final Set<Long2> messageIds = new HashSet<Long2>();
        private final Set<Long2> voiceStateIds = new HashSet<Long2>();

        public ChannelContent(long channelId) {
            this.channelId = channelId;
        }

        private void dispose() {
            LocalStoreLayout.this.channels.remove(this.channelId);
            LocalStoreLayout.this.contentByChannel.remove(this.channelId);
            LocalStoreLayout.this.messages.keySet().removeAll(this.messageIds);
        }
    }

    private class GuildContent {
        private final long guildId;
        private final Set<Long> channelIds = new HashSet<Long>();
        private final Set<Long> emojiIds = new HashSet<Long>();
        private final Set<Long2> memberIds = new HashSet<Long2>();
        private final Set<Long2> presenceIds = new HashSet<Long2>();
        private final Set<Long> roleIds = new HashSet<Long>();
        private final Set<Long2> voiceStateIds = new HashSet<Long2>();
        private volatile boolean memberListComplete;

        public GuildContent(long guildId) {
            this.guildId = guildId;
        }

        private void completeMemberList() {
            this.memberListComplete = true;
        }

        private boolean isMemberListComplete() {
            return this.memberListComplete;
        }

        @Nullable
        private GuildData dispose() {
            WrappedGuildData old = (WrappedGuildData)LocalStoreLayout.this.guilds.remove(this.guildId);
            LocalStoreLayout.this.contentByGuild.remove(this.guildId);
            LocalStoreLayout.this.contentByChannel.values().stream().filter(content -> this.channelIds.contains(((ChannelContent)content).channelId)).collect(Collectors.toSet()).forEach(rec$ -> ((ChannelContent)rec$).dispose());
            LocalStoreLayout.this.emojis.keySet().removeAll(this.emojiIds);
            LocalStoreLayout.this.members.keySet().removeAll(this.memberIds);
            LocalStoreLayout.this.presences.keySet().removeAll(this.presenceIds);
            LocalStoreLayout.this.roles.keySet().removeAll(this.roleIds);
            LocalStoreLayout.this.voiceStates.keySet().removeAll(this.voiceStateIds);
            return (GuildData)ImplUtils.ifNonNullMap(old, WrappedGuildData::unwrap);
        }
    }

    private static class EmojiKey {
        private final long id;
        private final String name;

        private EmojiKey(EmojiData emoji) {
            this.id = emoji.id().map(Id::asLong).orElse(-1L);
            this.name = emoji.name().orElse(null);
        }

        private static Predicate<ReactionData> predicateEquals(EmojiData emoji) {
            return r -> new EmojiKey(r.emoji()).equals(new EmojiKey(emoji));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmojiKey emojiKey = (EmojiKey)o;
            return this.id != -1L ? this.id == emojiKey.id : Objects.equals(this.name, emojiKey.name);
        }

        public int hashCode() {
            return this.id != -1L ? Long.hashCode(this.id) : Objects.hash(this.name);
        }
    }

    private static class Long2 {
        private final long a;
        private final long b;

        private Long2(long a, long b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Long2)) {
                return false;
            }
            Long2 long2 = (Long2)o;
            return this.a == long2.a && this.b == long2.b;
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }
    }
}

