/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store;

import discord4j.common.store.action.gateway.ChannelCreateAction;
import discord4j.common.store.action.gateway.ChannelDeleteAction;
import discord4j.common.store.action.gateway.ChannelUpdateAction;
import discord4j.common.store.action.gateway.CompleteGuildMembersAction;
import discord4j.common.store.action.gateway.GuildCreateAction;
import discord4j.common.store.action.gateway.GuildDeleteAction;
import discord4j.common.store.action.gateway.GuildEmojisUpdateAction;
import discord4j.common.store.action.gateway.GuildMemberAddAction;
import discord4j.common.store.action.gateway.GuildMemberRemoveAction;
import discord4j.common.store.action.gateway.GuildMemberUpdateAction;
import discord4j.common.store.action.gateway.GuildMembersChunkAction;
import discord4j.common.store.action.gateway.GuildRoleCreateAction;
import discord4j.common.store.action.gateway.GuildRoleDeleteAction;
import discord4j.common.store.action.gateway.GuildRoleUpdateAction;
import discord4j.common.store.action.gateway.GuildUpdateAction;
import discord4j.common.store.action.gateway.InvalidateShardAction;
import discord4j.common.store.action.gateway.MessageCreateAction;
import discord4j.common.store.action.gateway.MessageDeleteAction;
import discord4j.common.store.action.gateway.MessageDeleteBulkAction;
import discord4j.common.store.action.gateway.MessageReactionAddAction;
import discord4j.common.store.action.gateway.MessageReactionRemoveAction;
import discord4j.common.store.action.gateway.MessageReactionRemoveAllAction;
import discord4j.common.store.action.gateway.MessageReactionRemoveEmojiAction;
import discord4j.common.store.action.gateway.MessageUpdateAction;
import discord4j.common.store.action.gateway.PresenceUpdateAction;
import discord4j.common.store.action.gateway.ReadyAction;
import discord4j.common.store.action.gateway.UserUpdateAction;
import discord4j.common.store.action.gateway.VoiceStateUpdateDispatchAction;
import discord4j.common.store.action.read.CountInGuildAction;
import discord4j.common.store.action.read.CountMessagesInChannelAction;
import discord4j.common.store.action.read.CountTotalAction;
import discord4j.common.store.action.read.CountVoiceStatesInChannelAction;
import discord4j.common.store.action.read.GetChannelByIdAction;
import discord4j.common.store.action.read.GetChannelsAction;
import discord4j.common.store.action.read.GetChannelsInGuildAction;
import discord4j.common.store.action.read.GetEmojiByIdAction;
import discord4j.common.store.action.read.GetEmojisAction;
import discord4j.common.store.action.read.GetEmojisInGuildAction;
import discord4j.common.store.action.read.GetExactMembersInGuildAction;
import discord4j.common.store.action.read.GetGuildByIdAction;
import discord4j.common.store.action.read.GetGuildsAction;
import discord4j.common.store.action.read.GetMemberByIdAction;
import discord4j.common.store.action.read.GetMembersAction;
import discord4j.common.store.action.read.GetMembersInGuildAction;
import discord4j.common.store.action.read.GetMessageByIdAction;
import discord4j.common.store.action.read.GetMessagesAction;
import discord4j.common.store.action.read.GetMessagesInChannelAction;
import discord4j.common.store.action.read.GetPresenceByIdAction;
import discord4j.common.store.action.read.GetPresencesAction;
import discord4j.common.store.action.read.GetPresencesInGuildAction;
import discord4j.common.store.action.read.GetRoleByIdAction;
import discord4j.common.store.action.read.GetRolesAction;
import discord4j.common.store.action.read.GetRolesInGuildAction;
import discord4j.common.store.action.read.GetUserByIdAction;
import discord4j.common.store.action.read.GetUsersAction;
import discord4j.common.store.action.read.GetVoiceStateByIdAction;
import discord4j.common.store.action.read.GetVoiceStatesAction;
import discord4j.common.store.action.read.GetVoiceStatesInChannelAction;
import discord4j.common.store.action.read.GetVoiceStatesInGuildAction;
import discord4j.common.store.api.ActionMapper;
import discord4j.common.store.api.StoreAction;
import discord4j.common.store.api.layout.DataAccessor;
import discord4j.common.store.api.layout.GatewayDataUpdater;
import discord4j.common.store.api.layout.StoreLayout;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class Store {
    private static final Store NO_OP = new Store(ActionMapper.empty());
    private final ActionMapper actionMapper;

    private Store(ActionMapper actionMapper) {
        this.actionMapper = actionMapper;
    }

    public static Store noOp() {
        return NO_OP;
    }

    public static Store fromLayout(StoreLayout layout) {
        return new Store(Store.layoutToMapper(layout));
    }

    private static ActionMapper layoutToMapper(StoreLayout layout) {
        ActionMapper dataAccessorMapper = Store.dataAccessorToMapper(layout.getDataAccessor());
        ActionMapper gatewayDataUpdaterMapper = Store.gatewayDataUpdaterToMapper(layout.getGatewayDataUpdater());
        ActionMapper customMapper = layout.getCustomActionMapper();
        return ActionMapper.aggregate(dataAccessorMapper, gatewayDataUpdaterMapper, customMapper);
    }

    private static ActionMapper dataAccessorToMapper(DataAccessor dataAccessor) {
        Objects.requireNonNull(dataAccessor);
        return ActionMapper.builder().map(CountMessagesInChannelAction.class, action -> dataAccessor.countMessagesInChannel(action.getChannelId())).map(CountVoiceStatesInChannelAction.class, action -> dataAccessor.countVoiceStatesInChannel(action.getGuildId(), action.getChannelId())).map(CountInGuildAction.class, action -> {
            switch (action.getEntity()) {
                case CHANNELS: {
                    return dataAccessor.countChannelsInGuild(action.getGuildId());
                }
                case EMOJIS: {
                    return dataAccessor.countEmojisInGuild(action.getGuildId());
                }
                case MEMBERS: {
                    return dataAccessor.countMembersInGuild(action.getGuildId());
                }
                case MEMBERS_EXACT: {
                    return dataAccessor.countExactMembersInGuild(action.getGuildId());
                }
                case PRESENCES: {
                    return dataAccessor.countPresencesInGuild(action.getGuildId());
                }
                case ROLES: {
                    return dataAccessor.countRolesInGuild(action.getGuildId());
                }
                case VOICE_STATES: {
                    return dataAccessor.countVoiceStatesInGuild(action.getGuildId());
                }
            }
            throw new IllegalArgumentException("Unhandled entity " + (Object)((Object)action.getEntity()));
        }).map(CountTotalAction.class, action -> {
            switch (action.getEntity()) {
                case CHANNELS: {
                    return dataAccessor.countChannels();
                }
                case EMOJIS: {
                    return dataAccessor.countEmojis();
                }
                case GUILDS: {
                    return dataAccessor.countGuilds();
                }
                case MEMBERS: {
                    return dataAccessor.countMembers();
                }
                case MESSAGES: {
                    return dataAccessor.countMessages();
                }
                case PRESENCES: {
                    return dataAccessor.countPresences();
                }
                case ROLES: {
                    return dataAccessor.countRoles();
                }
                case USERS: {
                    return dataAccessor.countUsers();
                }
                case VOICE_STATES: {
                    return dataAccessor.countVoiceStates();
                }
            }
            throw new IllegalArgumentException("Unhandled entity " + (Object)((Object)action.getEntity()));
        }).map(GetChannelsAction.class, action -> dataAccessor.getChannels()).map(GetChannelsInGuildAction.class, action -> dataAccessor.getChannelsInGuild(action.getGuildId())).map(GetChannelByIdAction.class, action -> dataAccessor.getChannelById(action.getChannelId())).map(GetEmojisAction.class, action -> dataAccessor.getEmojis()).map(GetEmojisInGuildAction.class, action -> dataAccessor.getEmojisInGuild(action.getGuildId())).map(GetEmojiByIdAction.class, action -> dataAccessor.getEmojiById(action.getGuildId(), action.getEmojiId())).map(GetGuildsAction.class, action -> dataAccessor.getGuilds()).map(GetGuildByIdAction.class, action -> dataAccessor.getGuildById(action.getGuildId())).map(GetMembersAction.class, action -> dataAccessor.getMembers()).map(GetMembersInGuildAction.class, action -> dataAccessor.getMembersInGuild(action.getGuildId())).map(GetExactMembersInGuildAction.class, action -> dataAccessor.getExactMembersInGuild(action.getGuildId())).map(GetMemberByIdAction.class, action -> dataAccessor.getMemberById(action.getGuildId(), action.getUserId())).map(GetMessagesAction.class, action -> dataAccessor.getMessages()).map(GetMessagesInChannelAction.class, action -> dataAccessor.getMessagesInChannel(action.getChannelId())).map(GetMessageByIdAction.class, action -> dataAccessor.getMessageById(action.getChannelId(), action.getMessageId())).map(GetPresencesAction.class, action -> dataAccessor.getPresences()).map(GetPresencesInGuildAction.class, action -> dataAccessor.getPresencesInGuild(action.getGuildId())).map(GetPresenceByIdAction.class, action -> dataAccessor.getPresenceById(action.getGuildId(), action.getUserId())).map(GetRolesAction.class, action -> dataAccessor.getRoles()).map(GetRolesInGuildAction.class, action -> dataAccessor.getRolesInGuild(action.getGuildId())).map(GetRoleByIdAction.class, action -> dataAccessor.getRoleById(action.getGuildId(), action.getRoleId())).map(GetUsersAction.class, action -> dataAccessor.getUsers()).map(GetUserByIdAction.class, action -> dataAccessor.getUserById(action.getUserId())).map(GetVoiceStatesAction.class, action -> dataAccessor.getVoiceStates()).map(GetVoiceStatesInChannelAction.class, action -> dataAccessor.getVoiceStatesInChannel(action.getGuildId(), action.getChannelId())).map(GetVoiceStatesInGuildAction.class, action -> dataAccessor.getVoiceStatesInGuild(action.getGuildId())).map(GetVoiceStateByIdAction.class, action -> dataAccessor.getVoiceStateById(action.getGuildId(), action.getUserId())).build();
    }

    private static ActionMapper gatewayDataUpdaterToMapper(GatewayDataUpdater gatewayDataUpdater) {
        Objects.requireNonNull(gatewayDataUpdater);
        return ActionMapper.builder().map(ChannelCreateAction.class, action -> gatewayDataUpdater.onChannelCreate(action.getShardIndex(), action.getChannelCreate())).map(ChannelDeleteAction.class, action -> gatewayDataUpdater.onChannelDelete(action.getShardIndex(), action.getChannelDelete())).map(ChannelUpdateAction.class, action -> gatewayDataUpdater.onChannelUpdate(action.getShardIndex(), action.getChannelUpdate())).map(GuildCreateAction.class, action -> gatewayDataUpdater.onGuildCreate(action.getShardIndex(), action.getGuildCreate())).map(GuildDeleteAction.class, action -> gatewayDataUpdater.onGuildDelete(action.getShardIndex(), action.getGuildDelete())).map(GuildEmojisUpdateAction.class, action -> gatewayDataUpdater.onGuildEmojisUpdate(action.getShardIndex(), action.getGuildEmojisUpdate())).map(GuildMemberAddAction.class, action -> gatewayDataUpdater.onGuildMemberAdd(action.getShardIndex(), action.getGuildMemberAdd())).map(GuildMemberRemoveAction.class, action -> gatewayDataUpdater.onGuildMemberRemove(action.getShardIndex(), action.getGuildMemberRemove())).map(GuildMembersChunkAction.class, action -> gatewayDataUpdater.onGuildMembersChunk(action.getShardIndex(), action.getGuildMembersChunk())).map(GuildMemberUpdateAction.class, action -> gatewayDataUpdater.onGuildMemberUpdate(action.getShardIndex(), action.getGuildMemberUpdate())).map(GuildRoleCreateAction.class, action -> gatewayDataUpdater.onGuildRoleCreate(action.getShardIndex(), action.getGuildRoleCreate())).map(GuildRoleDeleteAction.class, action -> gatewayDataUpdater.onGuildRoleDelete(action.getShardIndex(), action.getGuildRoleDelete())).map(GuildRoleUpdateAction.class, action -> gatewayDataUpdater.onGuildRoleUpdate(action.getShardIndex(), action.getGuildRoleUpdate())).map(GuildUpdateAction.class, action -> gatewayDataUpdater.onGuildUpdate(action.getShardIndex(), action.getGuildUpdate())).map(InvalidateShardAction.class, action -> gatewayDataUpdater.onShardInvalidation(action.getShardIndex(), action.getCause())).map(MessageCreateAction.class, action -> gatewayDataUpdater.onMessageCreate(action.getShardIndex(), action.getMessageCreate())).map(MessageDeleteAction.class, action -> gatewayDataUpdater.onMessageDelete(action.getShardIndex(), action.getMessageDelete())).map(MessageDeleteBulkAction.class, action -> gatewayDataUpdater.onMessageDeleteBulk(action.getShardIndex(), action.getMessageDeleteBulk())).map(MessageReactionAddAction.class, action -> gatewayDataUpdater.onMessageReactionAdd(action.getShardIndex(), action.getMessageReactionAdd())).map(MessageReactionRemoveAction.class, action -> gatewayDataUpdater.onMessageReactionRemove(action.getShardIndex(), action.getMessageReactionRemove())).map(MessageReactionRemoveAllAction.class, action -> gatewayDataUpdater.onMessageReactionRemoveAll(action.getShardIndex(), action.getMessageReactionRemoveAll())).map(MessageReactionRemoveEmojiAction.class, action -> gatewayDataUpdater.onMessageReactionRemoveEmoji(action.getShardIndex(), action.getMessageReactionRemoveEmoji())).map(MessageUpdateAction.class, action -> gatewayDataUpdater.onMessageUpdate(action.getShardIndex(), action.getMessageUpdate())).map(PresenceUpdateAction.class, action -> gatewayDataUpdater.onPresenceUpdate(action.getShardIndex(), action.getPresenceUpdate())).map(ReadyAction.class, action -> gatewayDataUpdater.onReady(action.getReady())).map(UserUpdateAction.class, action -> gatewayDataUpdater.onUserUpdate(action.getShardIndex(), action.getUserUpdate())).map(VoiceStateUpdateDispatchAction.class, action -> gatewayDataUpdater.onVoiceStateUpdateDispatch(action.getShardIndex(), action.getVoiceStateUpdateDispatch())).map(CompleteGuildMembersAction.class, action -> gatewayDataUpdater.onGuildMembersCompletion(action.getGuildId())).build();
    }

    public <R> Publisher<R> execute(StoreAction<R> action) {
        return this.actionMapper.findHandlerForAction(action).map(h -> (Publisher)h.apply(action)).orElse((Publisher)Flux.empty());
    }
}

